# FSCompositePage - Composite Pages as Filesystem Objects
# Copyright (C) 2004 Enfold Systems, LLC
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
$Id: fssnippet.py,v 1.3 2005/04/27 01:09:33 dreamcatcher Exp $
"""

from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore.FSPageTemplate import FSPageTemplate
from Products.CMFCore.DirectoryView import registerFileExtension, registerMetaType
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import ViewManagementScreens, View
from Products.FSCompositePage.config import debug

class FSCompositeSnippet(FSPageTemplate):
    """ A Page Template that renders a snippet of HTML to
    be reused on Composite Pages
    """

    meta_type = 'Filesystem Composite Snippet'

    security = ClassSecurityInfo()
    security.declareObjectProtected(View)

    security.declareProtected(ViewManagementScreens, 'manage_doCustomize')
    def manage_doCustomize(self, folder_path, RESPONSE=None):
        """Makes a ZODB Based clone with the same data.

        Calls _createZODBClone for the actual work.
        """
        try:
            from Products.CompositePack import viewlet
            ct = getToolByName(self, 'composite_tool')
            viewlets = ct.viewlets
            name = '%s_%s' % ('_'.join(folder_path.split('/')), self.getId())
            template_path = '/'.join(('portal_skins', folder_path, self.getId()))
            viewlet.addViewlet(viewlets, name, template_path=template_path)
        except ImportError:
            debug('CompositePack not found, not registering '
                  'customized snipped as viewlet.')
        return FSPageTemplate.manage_doCustomize(self, folder_path, RESPONSE)

InitializeClass(FSCompositeSnippet)

registerFileExtension('cos', FSCompositeSnippet)
registerMetaType('Page Template', FSCompositeSnippet)
