# FSCompositePage - Composite Pages as Filesystem Objects
# Copyright (C) 2004 Enfold Systems, LLC
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
$Id: element.py,v 1.2 2005/04/27 01:09:33 dreamcatcher Exp $
"""
import os

from Globals import InitializeClass
from Acquisition import aq_parent
from Products.CompositePage.element import CompositeElement
from Products.CompositePage.interfaces import IComposite
from Products.PageTemplates.PageTemplateFile import PageTemplateFile

_www = os.path.join(os.path.dirname(__file__), "www")

class BoundCompositeElement(CompositeElement):
    """A smart Composite Element that binds
    itself to the context of the Composite Page.
    """

    meta_type = "Bound Composite Element"

    _properties = (
        {'id': 'template_name', 'type': 'string', 'mode': 'w',},
        )

    def __init__(self, id, template_name):
        self.id = id
        self.template_name = template_name

    def dereference(self):
        """Return the object referenced by this
        element. In our case, this is the context of the
        CompositePage
        """
        parent = aq_parent(self)
        current = self
        while parent and not IComposite.isImplementedBy(current):
            current = parent
            parent = aq_parent(current)
        return parent

InitializeClass(BoundCompositeElement)

addElementForm = PageTemplateFile('addElementForm', _www)

def manage_addElement(dispatcher, id, template_name, REQUEST=None):
    """Adds an element to a slot.
    """
    ob = BoundCompositeElement(str(id), template_name)
    dispatcher._setObject(ob.getId(), ob)
    if REQUEST is not None:
        return dispatcher.manage_main(dispatcher, REQUEST)
