# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from Acquisition import aq_base

from Products.CMFCore.utils import getToolByName
from Products.CMFStaging.VersionsTool import UseVersionControl, VersionsTool as BaseTool
from Products.CMFStaging.staging_utils import verifyPermission
from Products.CMFStaging.staging_utils import unproxied

from Products.ZopeVersionControl.nonversioned import isAVersionableResource as isVersionable

class VersioningTool(BaseTool):
    """ A Versioning Tool  """

    meta_type = 'Versioning Tool'

    def tag(self, obj, label):
        raise NotImplementedError("tags should be kept in the "
                                  "workspace tool alone")
##        repo = self._getVersionRepository()
##        repo.labelResource(obj, label, force=1)
##        return obj

    def getObjByInfo(self, info):
        repo = self._getVersionRepository()
        history = repo.getVersionHistory(info.history_id)
        version = history.getVersionById(info.version_id)
        new_object = version.copyState()
        return new_object

    def isValidLabel(self, label):
        return self._getVersionRepository()._labels.has_key(label)

    def checkin(self, obj, message=None):
        """Checks in a new version.

        overrides CMFStaging.checkin() so as not to look at the uptodateness
        of objects, which is broken in the presence of copied objects.
        Instead make pretend the object is up-to-date.
        """
        verifyPermission(UseVersionControl, obj)
        obj = unproxied(obj)
        repo = self._getVersionRepository()
        if not repo.isUnderVersionControl(obj):
            repo.applyVersionControl(obj, message)
        else:
            self._fakeUpToDate(obj)
            repo.checkinResource(obj, message or '')
        return None

    def _fakeUpToDate(self, obj):
        repo = self._getVersionRepository()
        info = repo.getVersionInfo(obj)
        branch = info.branchName()
        vhistory = repo.getVersionHistory(info.history_id)
        info.version_id = vhistory.getLatestVersion(branch).id

    def maybeCheckin(self, obj, message=None):
        repo = self._getVersionRepository()
        __traceback_info__ = (repo, obj, message)
        if not repo.isUnderVersionControl(obj):
            repo.applyVersionControl(obj, message)
        # This is unreliable if you are working inside
        # the same transaction
        # if not repo.isResourceChanged(obj):
        #    if self.isCheckedOut(obj):
        #        repo.uncheckoutResource(obj)
        #    return False
        if self.isCheckedOut(obj):
            self.checkin(obj, message)
        return True

    def maybeUnCheckout(self, obj, message=None):
        repo = self._getVersionRepository()
        if not repo.isUnderVersionControl(obj):
            repo.applyVersionControl(obj, message)
        elif self.isCheckedOut(obj):
            repo.uncheckoutResource(obj)
            return True
        # already under vc and checked in:
        return False

    def maybeCheckout(self, obj, message=None):
        repo = self._getVersionRepository()
        if not repo.isUnderVersionControl(obj):
            # not-yet-versioned resources will be versioned
            # during maybeCheckin, which should be called
            # immediately before this one.
            return None
        if not self.isCheckedOut(obj):
            self._fakeUpToDate(obj)
            repo.checkoutResource(obj)
            return True
        return False

    def maybeApplyVersionControl(self, obj, message=None):
        repo = self._getVersionRepository()
        if not repo.isUnderVersionControl(obj):
            repo.applyVersionControl(obj, message)
            return True
        return False

    def maybeUnstickObject(self, obj):
        # unstick the object if it has a non-branch sticky tag:
        repo = self._getVersionRepository()
        info = repo.getVersionInfo(obj)
        if info.sticky and info.sticky[0] != 'B':
            # let the class .sticky attribute (None) take over
            del info.sticky
