# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

class TestTools(TestStaging):

    def testStagingToolStageListHandling(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        adv = self.home.adv
        sales = self.home.sales
        dst_mkt = makeContent(self.portal, 'Folder', id='mkt')
        dst_sales = makeContent(dst_mkt, 'Folder', id='sales')
        dst_adv = makeContent(dst_sales, 'Folder', id='adv')
        # let's set the stages a little bit out of order
        mkt.setStagePath('mkt')
        adv.setStagePath('mkt/sales/adv')
        sales.setStagePath('mkt/sales')

        for folder in dst_mkt, dst_adv, dst_sales:
            stage = self.wt.getStageFor(folder)
            self.assertEquals(folder, stage, "folder: %s != stage: %s" %
                              (folder.absolute_url(), stage.absolute_url()))

    def testValidStageUIDs(self):
        # this test is here because someone forgot to call the base
        # classes of archetypes while overriding some methods.
        self.setupStagingAreas()
        self.assertNotEquals(self.home.mkt.UID(), self.home.adv.UID())
        self.assertNotEquals(self.home.mkt.UID(), self.home.sales.UID())

    def testTools(self):
        from Products.EnSimpleStaging.tools import locking, versioning, workspaces
        toolIds2Classes = [('portal_workspaces', workspaces.WorkspacesTool),
                           ('portal_versions', versioning.VersioningTool),
                           ('portal_lock', locking.LockingTool)]
        for toolId, toolClass in toolIds2Classes:
            instance = getToolByName(self.portal, toolId)
            self.assertEqual(instance.__class__, toolClass)


    def testNoDuplicateStages(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        adv = self.home.adv
        mkt.setStagePath('public_website')
        self.assertRaises(ValueError, adv.setStagePath, 'public_website')

class TestCatalog(TestStaging):

    def testCatalogIsUpdating(self):
        self.setupStagingAreas()
        cat = self.portal.portal_catalog
        ut = self.portal.plone_utils
        pubsite = self.portal.public_website
        pubsitepath = "/".join(pubsite.getPhysicalPath())
        mkt = self.home.mkt
        mkt.setStagePath('public_website')
        f1 = makeContent(mkt, 'Folder', id='folder1')
        ut.contentEdit(f1, title='title 1')
        self.assertEquals(f1.Title(), 'title 1')
        # the catalog shouldn't show folder1 inside public_website yet
        self.failIf(cat(id='folder1', path=pubsitepath))
        # now lets publish and see it's there
        mkt.publishStage('test1')
        self.assertEquals(pubsite.folder1.Title(), 'title 1')
        results = cat(id='folder1', path=pubsitepath)
        self.assertEquals(len(results), 1)
        brain = results[0]
        self.assertEquals(brain.Title, 'title 1')
        # now let's put an object inside the published folder
        # to keep it from being erased by recursiveWipeStage
        pubsite.folder1.invokeFactory('Document', id='doc1')
        # and change the source object title
        ut.contentEdit(f1, title='title 2')
        # now lets publish and see if the catalog updated accordingly
        mkt.publishStage('test2')
        self.assertEquals(pubsite.folder1.Title(), 'title 2')
        results = cat(id='folder1', path=pubsitepath)
        self.assertEquals(len(results), 1)
        brain = results[0]
        self.assertEquals(brain.Title, 'title 2')
        # so, now we have a 'title 2' object in the workspace, right?
        nodepath = "/".join(mkt.getPhysicalPath())
        results = cat(id='folder1', path=nodepath)
        self.assertEquals(len(results), 1)
        brain = results[0]
        self.assertEquals(brain.Title, 'title 2')
        # in this case, if we revert the stage...
        mkt.updateStage(mkt._globalLabel('test1'))
        # the folder will once again have the old title
        self.assertEquals(f1.Title(), 'title 1')
        # so the catalog info should have the old title too
        nodepath = "/".join(mkt.getPhysicalPath())
        results = cat(id='folder1', path=nodepath)
        self.assertEquals(len(results), 1)
        brain = results[0]
        self.assertEquals(brain.Title, 'title 1')

class TestLocking(TestStaging):

    def testCannotPublishIfLocked(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setStagePath('public_website')
        lt = self.portal.portal_lock
        wt = self.portal.portal_workspaces
        lt.lock(wt)
        from Products.EnSimpleStaging import StagingError
        self.assertRaises(StagingError, mkt.publishStage, 'test1')

class TestZopeVersionControl(ZopeTestCase.ZopeTestCase):

    def afterSetUp(self):
        self.app.manage_addProduct['OFSP'].manage_addFolder('afolder1')
        self.afolder1 = self.app.afolder1
        self.app.manage_addProduct['ZopeVersionControl'].addRepository('repo')
        self.repo = self.app.repo

    def testNonVersionable(self):
        self.afolder1.manage_addFolder('afolder11')
        self.afolder1.afolder11.__non_versionable__ = True
        self.afolder1.manage_addFolder('afolder12')
        self.repo.applyVersionControl(self.afolder1)
        vi = self.app.repo.getVersionInfo(self.afolder1)
        versobj = self.app.repo.getVersionOfResource(vi.history_id,
                                                 vi.version_id)
        result = versobj.restrictedTraverse('afolder11', None)
        self.failUnless(result, "did not find afolder11")
        result = versobj.restrictedTraverse('afolder12', None)
        self.failIf(result, "found misplaced %s")

##    def test_isResourceChanged(self):
##        self.repo.applyVersionControl(self.afolder1)
##        self.failIf(self.repo.isResourceChanged(self.afolder1))
##        self.afolder1.manage_changeProperties(title='new title')
##        get_transaction().commit(1)
##        # let's sleep a little
##        import time
##        time.sleep(1)
##        self.failUnless(self.repo.isResourceChanged(self.afolder1))

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for testclass in (
        TestTools,
        TestCatalog,
        TestLocking,
        TestZopeVersionControl,
        ):
        suite.addTest(makeSuite(testclass))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
