# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

class TestLabelingTagOnly(TestStaging):

    def testLabeling(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setInPlace(True)
        public = self.public
        public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        self._populateFolder(mkt)

        # Publish stage, with a label
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)
        mkt.publishStage(label='test1')
        # public.marketing should be empty, because we have 'tag-only'
        # set to True so it just does a tag.
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

        info = mkt.getLastAnnotation()
        self.assertEquals(info['operation'], 'tag')
        self.assertEquals(info['args'].get('label'), mkt.UID()+'-'+'test1')
        self.assertEquals(info['user'],'portal_owner')
        self.assertEquals(info['count'], self.P_COUNT)

        # Check that we don't have any structure inside folder1
        self.failUnless(self._checkStructure(public.marketing))

        # Populate folder1, and publish with another label
        self._populateFolder(mkt.folder1)
        mkt.publishStage(label='test2')
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

        info = mkt.getLastAnnotation()
        self.assertEquals(info['operation'], 'tag')
        self.assertEquals(info['args'].get('label'), mkt.UID()+'-'+'test2')
        self.assertEquals(info['user'], 'portal_owner')
        self.assertEquals(info['count'], self.P_COUNT * 2)

        # Update to previous label, and make sure
        # the structure inside folder1 is gone
        mkt.updateStage(label=mkt.UID()+'-'+'test1')
        errors = self._checkStructure(mkt)
        self.failIf(errors, errors)
        errors = self._checkStructure(mkt.folder1)
        self.failUnless(errors, errors)

        info = mkt.getLastAnnotation()
        self.assertEquals(info['operation'], 'update')
        self.assertEquals(info['args'].get('label'), mkt.UID()+'-'+'test1')
        self.assertEquals(info['user'], 'portal_owner')
        self.assertEquals(info['count'], self.P_COUNT)

        # Now, update to the other label again and check that
        # the structure inside folder1 is back
        mkt.updateStage(label=mkt.UID()+'-'+'test2')
        errors = self._checkStructure(mkt)
        self.failIf(errors, errors)
        errors = self._checkStructure(mkt.folder1)
        self.failIf(errors, errors)

        info = mkt.getLastAnnotation()
        self.failIf(info['operation'] != 'update')
        self.failIf(info['args'].get('label') != mkt.UID()+'-'+'test2')
        self.failIf(info['user'] != 'portal_owner')
        self.failIf(info['count'] != self.P_COUNT * 2, info['count'])

    def testRevertToPreviousLabel(self):
        # Lets make a label or two.  Delete the entire
        # stage contents and revert to a previous label.
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setInPlace(True)
        public = self.public

        public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        self._populateFolder(mkt)

        # Publish stage, with a label
        self.failUnless(self._checkStructure(public.marketing))
        mkt.publishStage(label='test1')
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

        # Check that path version info has been saved
        # for that label
        stage = self.wt.getStageOf(mkt)
        p_info = self.wt.getTagAnnotationForPath(path='',
                                                 label=mkt.UID()+'-'+'test1',
                                                 stage=stage)
        self.assertEquals(len(p_info), 4)

        # Now lets remove everyting and revert to label
        mkt.manage_delObjects(mkt.objectIds())
        mkt.updateStage(mkt.UID()+'-'+'test1')
        errors = self._checkStructure(mkt)
        self.failIf(errors, errors)

    def testPublishDeletePublish(self):
        # We will create a hierarchy, publish,
        # delete a subtree and publish again.
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setInPlace(True)
        public = self.public

        public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        self._populateFolder(mkt)
        self._populateFolder(mkt.folder1.folder11)

        # Publish stage, with a label
        self.failUnless(self._checkStructure(public.marketing))
        mkt.publishStage(label='test1')
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

        # Now, delete a subtree and publish again.
        f11 = mkt.folder1.folder11
        f11.manage_delObjects(ids=f11.objectIds())
        mkt.publishStage(label='test2')
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

        # Revert to label 1, and publish.
        mkt.updateStage(mkt.UID()+'-'+'test1')
        mkt.publishStage()
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

        # Now, delete the contents of folder11 in source stage
        # and publish.
        f11 = mkt.folder1.folder11
        f11.manage_delObjects(ids=f11.objectIds())
        mkt.publishStage(label='test3')
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)

    def testRenameAndRevert(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setInPlace(True)
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Folder', 'afolder')
        mkt.afolder.invokeFactory('Document', 'doc1')
        # publish
        self.commit()
        mkt.publishStage(label='1')
        # rename and publish again
        self.commit()
        mkt.afolder.manage_renameObject('doc1', 'doc2')
        self.commit()
        mkt.publishStage(label='2')
        # revert and publish again
        mkt.updateStage(mkt._globalLabel('1'))
        mkt.publishStage(label='3')

    def testRenameAndRevertAfterIncremental(self):
        # same as before, but using incremental publish
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setInPlace(True)
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Folder', 'afolder')
        mkt.afolder.invokeFactory('Document', 'doc1')
        self.commit()
        # publish
        mkt.publishStage(label='1')
        # rename and publish again
        self.commit()
        mkt.afolder.manage_renameObject('doc1', 'doc2')
        self.commit()
        mkt.publishLastChanged(label='2')
        # revert and publish again
        mkt.updateStage(mkt._globalLabel('1'))
        mkt.publishStage(label='3')

    def testMovementsAndModificationsLabels(self):
        # Test diffs between random labels.
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setInPlace(True)

        # Make two tags.
        mkt.saveStage(label='1')
        mkt.saveStage(label='2', force_tag=True)

        getChanges = mkt.getMovementsAndModifications

        # Everything should be empty.
        info = getChanges('1', '2')
        self.failIf(info['adds'])
        self.failIf(info['modifications'])
        self.failIf(info['removes'])

        # Inverse too.
        info = getChanges('2', '1')
        self.failIf(info['adds'])
        self.failIf(info['modifications'])
        self.failIf(info['removes'])

        # Added f1, f1/d11 and d1
        mkt.invokeFactory('Folder', 'f1')
        mkt.f1.invokeFactory('Document', 'd11', title='Document One')
        mkt.invokeFactory('Document', 'd1')
        mkt.invokeFactory('Document', 'd2')
        mkt.saveStage(label='3', force_tag=True)

        info = getChanges('2', '3')
        self.assertEquals(info['adds'], [('d1',), ('d2',),
                                         ('f1',), ('f1', 'd11')])
        self.assertEquals(info['modifications'], [])
        self.assertEquals(info['removes'], [])

        # Now the inverse.
        info = getChanges('3', '2')
        self.assertEquals(info['adds'], [])
        self.assertEquals(info['modifications'], [])
        self.assertEquals(info['removes'], [('d1',), ('d2',),
                                            ('f1',), ('f1', 'd11')])

        # Added f2, f2/d21 and removed d1, modify d2
        mkt.invokeFactory('Folder', 'f2')
        mkt.f2.invokeFactory('Document', 'd21')
        mkt.manage_delObjects(ids=['d1'])
        # Trigger a modification
        self.vt.checkout(mkt.d2)
        mkt.d2.setTitle('Document 2')
        self.vt.checkin(mkt.d2)
        mkt.saveStage(label='4')

        info = getChanges('3', '4')
        self.assertEquals(info['adds'], [('f2',), ('f2', 'd21')])
        self.assertEquals(info['modifications'], [('d2',)])
        self.assertEquals(info['removes'], [('d1',)])

        # And now the inverse.
        info = getChanges('4', '3')
        self.assertEquals(info['adds'], [('d1',)])
        self.assertEquals(info['modifications'], [('d2',)])
        self.assertEquals(info['removes'], [('f2',), ('f2', 'd21')])

        # Renamed 'd21' to 'd21a', equals to remove 'd21' and add 'd21a'
        self.commit()
        mkt.f2.manage_renameObjects(ids=['d21'], new_ids=['d21a'])
        mkt.saveStage(label='5')

        info = getChanges('4', '5')
        self.assertEquals(info['adds'], [('f2', 'd21a')])
        # Doing a saveStage only doesn't trigger a modification on the
        # folder. Odd.
        # self.assertEquals(info['modifications'], [('f2',)])
        self.assertEquals(info['modifications'], [])
        self.assertEquals(info['removes'], [('f2', 'd21',)])

        # The inverse.
        info = getChanges('5', '4')
        self.assertEquals(info['adds'], [('f2', 'd21',)])
        # Doing a saveStage only doesn't trigger a modification on the
        # folder. Odd.
        # self.assertEquals(info['modifications'], [('f2',)])
        self.assertEquals(info['modifications'], [])
        self.assertEquals(info['removes'], [('f2', 'd21a')])

        # Renamed 'f2' to 'f2a', equals to remove f2, f2/d21a and add
        # f2a and f2/d21a
        self.commit()
        mkt.manage_renameObjects(ids=['f2'], new_ids=['f2a'])
        mkt.saveStage(label='6')

        info = getChanges('5', '6')
        self.assertEquals(info['adds'], [('f2a',), ('f2a', 'd21a')])
        self.assertEquals(info['modifications'], [])
        self.assertEquals(info['removes'], [('f2',), ('f2', 'd21a',)])

        # The inverse.
        info = getChanges('6', '5')
        self.assertEquals(info['adds'], [('f2',), ('f2', 'd21a',)])
        self.assertEquals(info['modifications'], [])
        self.assertEquals(info['removes'], [('f2a',), ('f2a', 'd21a')])

        # Three tags apart
        info = getChanges('3', '6')
        self.assertEquals(info['adds'], [('f2a',), ('f2a', 'd21a')])
        self.assertEquals(info['modifications'], [('d2',)])
        self.assertEquals(info['removes'], [('d1',)])

        # Inverse.
        info = getChanges('6', '3')
        self.assertEquals(info['adds'], [('d1',)])
        self.assertEquals(info['modifications'], [('d2',)])
        self.assertEquals(info['removes'], [('f2a',), ('f2a', 'd21a')])


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for testclass in (
        TestLabelingTagOnly,
        ):
        suite.addTest(makeSuite(testclass))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
