# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

class TestStagingArea(PloneTestCase.PloneTestCase):

    def afterSetUp(self):
        self.loginAsPortalOwner()
        self.qi = self.portal.portal_quickinstaller
        self.qi.installProduct('EnSimpleStaging')
        self.mt = self.portal.portal_membership
        self.wt = self.portal.portal_workspaces
        self.vt = self.portal.portal_versions
        self.acl_users = self.portal.acl_users
        home = self.mt.getHomeFolder()
        if home is None:
            # Plone 2.1
            member_id = self.mt.getAuthenticatedMember().getId()
            home = makeContent(self.portal.Members, 'Folder', id=member_id)
        self.home = home
        if not 'public_website' in self.portal.objectIds():
            self.public = makeContent(self.portal, 'Folder', id='public_website')

    def setupStagingAreas(self):
        for area in 'mkt adv sales'.split():
            areaTitle = area + ' staging area'
            if area in self.home.objectIds():
                self.home.manage_delObjects([area])
            self.home.invokeFactory('StagingArea', area, title=areaTitle)

    def testStagingAreaOrderSupport(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setStagePath('public_website')
        pubnode = mkt
        pubsite = self.portal.public_website
        it = getToolByName(self.portal, 'portal_interface')
        iord_str = ('Products.CMFPlone.interfaces.'
                    'OrderedContainer.IOrderedContainer')
        self.failUnless(it.objectImplements(pubnode, iord_str),
                        'staging area not orderable')
        # create subfolders, deploy, check order
        pubnode.invokeFactory('Folder', id='a')
        pubnode.invokeFactory('Folder', id='b')
        self.failUnlessEqual(pubnode.objectIds(), ['a', 'b'])
        mkt.publishStage('test1')
        self.failUnlessEqual(pubsite.objectIds(), ['a', 'b'])
        # move subfolders around, deploy, check order
        pubnode.moveObjectsUp('b')
        self.failUnlessEqual(pubnode.objectIds(), ['b', 'a'])
        mkt.publishStage('test2')
        self.failUnlessEqual(pubsite.objectIds(), ['b', 'a'])

class TestEnSimpleStaging(TestStaging):

    def testSetup(self):
        self.setupStagingAreas()
        self.failUnless(hasattr(self.home, 'mkt'))

    def test_getStageItems(self):
        wt = self.wt
        self.setupStagingAreas()
        numstages = len(wt.getStageItems())
        self.assertEquals(numstages, 3,
                          "Destinations unset but %s stages" % numstages)
        mkt = self.home.mkt
        adv = self.home.adv
        sales = self.home.sales
        mktID = mkt.UID()
        advID = adv.UID()
        salesID = sales.UID()
        public = self.public
        public.invokeFactory('Folder', id='marketing')
        public.invokeFactory('Folder', id='sales')
        public.marketing.invokeFactory('Folder', id='advertising')
        mkt.setStagePath('public_website/marketing')
        adv.setStagePath('public_website/marketing/advertising')
        sales.setStagePath('public_website/sales')
        tool_stages = wt.getStageItems()
        self.failUnless(tool_stages)
        # let's make our own list from the stages (and make sure it's a list)
        tool_stages = list(tool_stages)
        tool_stages.sort()
        expect = [('dst_%s' % mktID, 'mkt staging area (destination)', 'public_website/marketing'),
                  ('dst_%s' % salesID, 'sales staging area (destination)', 'public_website/sales'),
                  ('dst_%s' % advID, 'adv staging area (destination)', 'public_website/marketing/advertising'),
                  ('src_%s' % mktID, 'mkt staging area (source)', 'Members/portal_owner/mkt'),
                  ('src_%s' % advID, 'adv staging area (source)', 'Members/portal_owner/adv'),
                  ('src_%s' % salesID, 'sales staging area (source)', 'Members/portal_owner/sales')]
        expect.sort()
        # I could have done a direct comparisson of the 2 lists, but
        # this way it's easier to spot the differences
        for i1, i2 in zip(expect, tool_stages):
            self.assertEquals(i1, i2)

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for testclass in (
        TestStagingArea,
        TestEnSimpleStaging,
        ):
        suite.addTest(makeSuite(testclass))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
