# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

class TestReferences(TestStaging):

    def testNonVersionable(self):
        # let's check to see if EnSimpleStaging will bomb on
        # non-versionable objects
        self.setupStagingAreas()
        mkt = self.home.mkt
        self.public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        # let's create a regular resource
        mkt.invokeFactory('Document', id='vers')
        # and a non-versionable one
        mkt.invokeFactory('Document', id='nonvers')
        mkt.nonvers.__non_versionable__ = True
        # now let's publish the stage and see if our
        # nonvers object hasn't been published
        mkt.publishStage(label='test')
        dest_mkt = self.portal.public_website.marketing
        self.failUnless(dest_mkt.restrictedTraverse('vers', None),
                        "Versionable resource wasn't published")
        #self.failIf(dest_mkt.restrictedTraverse('nonvers', None),
        #                "Non-versionable resource was published")

    def XXXtestStagingReferenceability(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        adv = self.home.adv
        sales = self.home.sales
        mkt.invokeFactory('InterStageReference', id='aRef')
        # compare received UIDs with known UIDs
        refs = [data[0] for data in
                mkt.aRef._referencedStagesData()]
        refs.sort()
        expected = [ob.UID() for ob in mkt, adv, sales]
        expected.sort()
        from pprint import pformat
        self.assertEquals(refs, expected,
                          "available references don't match: %s" %
                          pformat((refs, expected)))

    def XXXtestReferencesUnpublisheability(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        self.public.invokeFactory('Folder', id='foo')
        mkt.setStagePath('public_website/foo')
        # let's create some references
        mkt.invokeFactory('InterStageReference', id='aRef')
        mkt.invokeFactory('Folder', id='aFolder')
        mkt.aFolder.invokeFactory('InterStageReference',
                                         id='anotherRef')
        # now let's publish and see if the references were included
        mkt.publishStage(label='test')
        dst = self.portal.public_website.foo
        self.failIf(dst.restrictedTraverse('aRef', None),
                    "reference at public node root was published")
        self.failIf(dst.aFolder.restrictedTraverse('anotherRef', None),
                    "reference deep in the staging area was published")

class TestATReferenceStaging(TestStaging):

    def afterSetUp(self):
        TestStaging.afterSetUp(self)
        self.setupStagingAreas()
        self.setupNestedSite()
        tt = self.portal.portal_types
        tt.manage_addTypeInformation('Factory-based Type Information',
                typeinfo_name='Archetypes: SimpleType')

    def testATReferencePublishing(self):
        mkt = self.home.mkt

        # Create the destination folder
        self.public.invokeFactory('Folder', id='foo')

        # Set the stage to point to the newly created folder
        mkt.setStagePath('public_website/foo')

        # Create two pieces of content in there
        mkt.invokeFactory(type_name='SimpleType', id='obj1')
        mkt.invokeFactory(type_name='SimpleType', id='obj3')
        obj1 = mkt.obj1
        obj3 = mkt.obj3

        # Create a piece of content *outside* the stages and also
        # outside the nested site.
        self.portal.invokeFactory(type_name='SimpleType', id='obj2')
        obj2 = self.portal.obj2

        # Add some references.
        obj1.addReference(obj2)
        obj1.addReference(obj3)
        self.assertEquals(obj2.getBRefs(), [obj1])
        self.assertEquals(obj1.getRefs(), [obj2, obj3])

        # Publish the stage.
        mkt.publishStage(label='test')
        dst = self.portal.public_website.foo
        orig_uid = obj1.UID()
        new_uid = dst.obj1.UID()
        # Objects in the nested site should keep the same UID.
        self.assertEquals(orig_uid, new_uid)

        new_obj1 = dst.obj1
        new_obj3 = dst.obj3
        obj2 = self.portal.obj2

        # obj2 should still have a reference to obj1
        self.assertEquals(obj2.getBRefs(), [obj1])

        # If we wrap obj2 in the nested site, it should find the
        # staged obj1 instead.
        w_obj2 = obj2.aq_base.__of__(self.portal.public_website)
        self.assertEquals(w_obj2.getBRefs(), [new_obj1])

        self.assertEquals(obj1.getRefs(), [obj2, obj3])
        # Should get None for obj2 as it's outside the
        # nested site, so can't be found by uid_catalog.
        self.assertEquals(new_obj1.getRefs(), [None, new_obj3])

        # Now, let's republish the stage and test it all over again.
        mkt.publishStage(label='test_again')
        new_obj1 = dst.obj1
        new_obj3 = dst.obj3

        # obj2 should still have a reference to obj1
        self.assertEquals(obj2.getBRefs(), [obj1])

        # If we wrap obj2 in the nested site, it should find the
        # staged obj1 instead.
        w_obj2 = obj2.aq_base.__of__(self.portal.public_website)
        self.assertEquals(w_obj2.getBRefs(), [new_obj1])

        self.assertEquals(obj1.getRefs(), [obj2, obj3])
        # Should get None for obj2 as it's outside the
        # nested site, so can't be found by uid_catalog.
        self.assertEquals(new_obj1.getRefs(), [None, new_obj3])

    def testATReferencePublishingSameWorkspace(self):
        mkt = self.home.mkt
        self.public.invokeFactory('Folder', id='foo')
        mkt.setStagePath('public_website/foo')
        mkt.invokeFactory(type_name='SimpleType', id='obj1')
        obj1 = mkt.obj1
        mkt.invokeFactory(type_name='SimpleType', id='obj2')
        obj2 = mkt.obj2
        obj1.addReference(obj2)
        self.assertEquals(obj2.getBRefs(), [obj1])
        self.assertEquals(obj1.getRefs(), [obj2])
        mkt.publishStage(label='test')
        dst = self.portal.public_website.foo
        obj1 = dst.obj1
        obj2 = dst.obj2
        self.assertEquals(obj2.getBRefs(), [obj1])
        self.assertEquals(obj1.getRefs(), [obj2])

    def testInterstageReferences(self):
        mkt = self.home.mkt
        adv = self.home.adv
        public = self.public
        public.invokeFactory('Folder', id='mkt')
        public.invokeFactory('Folder', id='adv')
        mkt.setStagePath('public_website/mkt')
        adv.setStagePath('public_website/adv')
        obj1 = makeContent(mkt, 'SimpleType', id='obj1')
        obj2 = makeContent(adv, 'SimpleType', id='obj2')
        # let's make a reference
        obj1.addReference(obj2)
        # now let's publish the stages
        mkt.publishStage('test1')
        adv.publishStage('test1')
        # so this means that the target obj1 will have a reference to
        # obj2
        new_obj1 = public.mkt.obj1
        new_obj2 = public.adv.obj2
        self.assertEquals(new_obj1.getRefs(), [new_obj2])
        self.assertEquals(new_obj2.getBRefs(), [new_obj1])
        # ok, so if we now republish the object that has the
        # reference, everything should be ok
        mkt.publishStage('test2')
        new_obj1 = public.mkt.obj1
        new_obj2 = public.adv.obj2
        self.assertEquals(new_obj1.getRefs(), [new_obj2])
        self.assertEquals(new_obj2.getBRefs(), [new_obj1])
        # just like when we republish the target of the reference
        adv.publishStage('test2')
        new_obj1 = public.mkt.obj1
        new_obj2 = public.adv.obj2
        self.assertEquals(new_obj1.getRefs(), [new_obj2])
        self.assertEquals(new_obj2.getBRefs(), [new_obj1])

    def testUIDProtection(self):
        self.home.mkt.setStagePath('public_website/mkt')
        obj = makeContent(self.home.mkt, 'SimpleType', id='obj')
        obj.addReference(obj)

        from Products.EnSimpleStaging.tools.workspaces import _protectUIDsUnder, _unprotectUIDsUnder
        # let's enable protection
        _protectUIDsUnder(self.home.mkt)
        self.failUnless(self.wt._isProtectedUID(obj.UID()),
                        "UID wasn't protected")
        from Products.Archetypes.exceptions import ReferenceException
        rc = self.portal.reference_catalog
        robj = rc.getReferences(obj)[0]
        from Products.EnSimpleStaging.patch import delHook
        self.assertEquals(robj.delHook.im_func, delHook)
        self.assertRaises(ReferenceException, robj.delHook,
                          rc, None, obj)
        self.assertRaises(ReferenceException, robj.delHook,
                          rc, obj, None)
        _unprotectUIDsUnder(self.home.mkt)
        self.failIf(self.wt._isProtectedUID(obj.UID()),
                    "UID was still protected")

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for testclass in (
        TestReferences,
        TestATReferenceStaging,
        ):
        suite.addTest(makeSuite(testclass))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
