# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

class TestLabeling(TestStaging):

    def testLabeling(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        public = self.public
        public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        self._populateFolder(mkt)

        # Publish stage, with a label
        errors = self._checkStructure(public.marketing)
        self.failUnless(errors, errors)
        mkt.publishStage(label='test1')
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)

        info = mkt.getLastAnnotation()
        self.assertEquals(info['operation'], 'publish+tag')
        self.assertEquals(info['args'].get('label'), mkt.UID()+'-'+'test1')
        self.assertEquals(info['user'],'portal_owner')
        self.assertEquals(info['count'], self.P_COUNT)

        # Check that we don't have any structure
        # inside folder1
        self.failUnless(self._checkStructure(public.marketing.folder1))
        self.failUnless(self._checkStructure(mkt.folder1))
        #self.failUnless(self.vt.isCheckedOut(mkt.folder1))
        # the default state for objects after publishing has been inverted
        self.failIf(self.vt.isCheckedOut(mkt.folder1))

        # Populate folder one, and publish with another label
        self._populateFolder(mkt.folder1)
        mkt.publishStage(label='test2')
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)
        errors = self._checkStructure(public.marketing.folder1)
        self.failIf(errors, errors)

        info = mkt.getLastAnnotation()
        self.assertEquals(info['operation'], 'publish+tag')
        self.assertEquals(info['args'].get('label'), mkt.UID()+'-'+'test2')
        self.assertEquals(info['user'], 'portal_owner')
        self.assertEquals(info['count'], self.P_COUNT * 2)

        # Update to previous label, and make sure
        # the structure inside folder1 is gone
        mkt.updateStage(label=mkt.UID()+'-'+'test1')
        errors = self._checkStructure(mkt)
        self.failIf(errors, errors)
        errors = self._checkStructure(mkt.folder1)
        self.failUnless(errors, errors)

        info = mkt.getLastAnnotation()
        self.assertEquals(info['operation'], 'update')
        self.assertEquals(info['args'].get('label'), mkt.UID()+'-'+'test1')
        self.assertEquals(info['user'], 'portal_owner')
        self.assertEquals(info['count'], self.P_COUNT)

        # Now, update to the other label again and check that
        # the structure inside folder1 is back
        mkt.updateStage(label=mkt.UID()+'-'+'test2')
        errors = self._checkStructure(mkt)
        self.failIf(errors, errors)
        errors = self._checkStructure(mkt.folder1)
        self.failIf(errors, errors)

        info = mkt.getLastAnnotation()
        self.failIf(info['operation'] != 'update')
        self.failIf(info['args'].get('label') != mkt.UID()+'-'+'test2')
        self.failIf(info['user'] != 'portal_owner')
        self.failIf(info['count'] != self.P_COUNT * 2, info['count'])

    def testRevertToPreviousLabel(self):
        # Lets make a label or two.  Delete the entire
        # stage contents and revert to a previous label.
        self.setupStagingAreas()
        mkt = self.home.mkt
        public = self.public

        public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        self._populateFolder(mkt)

        # Publish stage, with a label
        self.failUnless(self._checkStructure(public.marketing))
        mkt.publishStage(label='test1')
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)

        # Check that path version info has been saved
        # for that label
        stage = self.wt.getStageOf(mkt)
        p_info = self.wt.getTagAnnotationForPath(path='',
                                                 label=mkt.UID()+'-'+'test1',
                                                 stage=stage)
        self.assertEquals(len(p_info), 4)

        # Now lets remove everyting and revert to label
        mkt.manage_delObjects(mkt.objectIds())
        mkt.updateStage(mkt.UID()+'-'+'test1')
        errors = self._checkStructure(mkt)
        self.failIf(errors, errors)

    def testPublishDeletePublish(self):
        # We will create a hierarchy, publish,
        # delete a subtree and publish again.
        self.setupStagingAreas()
        mkt = self.home.mkt
        public = self.public

        public.invokeFactory('Folder', id='marketing')
        mkt.setStagePath('public_website/marketing')
        self._populateFolder(mkt)
        self._populateFolder(mkt.folder1.folder11)

        # Publish stage, with a label
        self.failUnless(self._checkStructure(public.marketing))
        mkt.publishStage(label='test1')
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)
        errors = self._checkStructure(public.marketing.folder1.folder11)
        self.failIf(errors, errors)

        # Now, delete a subtree and publish again.
        # Content inside 'folder1' of public side
        # should be gone.
        f11 = mkt.folder1.folder11
        f11.manage_delObjects(ids=f11.objectIds())
        mkt.publishStage(label='test2')
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)
        errors = self._checkStructure(public.marketing.folder1.folder11)
        self.failUnless(errors, errors)

        # Revert to label 1, and publish.
        mkt.updateStage(mkt.UID()+'-'+'test1')
        mkt.publishStage()
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)
        errors = self._checkStructure(public.marketing.folder1.folder11)
        self.failIf(errors, errors)

        # Create a document at the root of public stage,
        # and another inside folder1.folder11.folder2
        public.marketing.invokeFactory('Document', id='doc3')
        f11_2 = public.marketing.folder1.folder11.folder2
        f11_2.invokeFactory('Document', id='doc4')

        # Now, delete the contents of folder11 in source stage
        # and publish.
        f11 = mkt.folder1.folder11
        f11.manage_delObjects(ids=f11.objectIds())
        mkt.publishStage(label='test3')
        errors = self._checkStructure(public.marketing)
        self.failIf(errors, errors)
        errors = self._checkStructure(public.marketing.folder1.folder11)
        self.failUnless(errors, errors)

        # And make sure doc3, doc4 and folder1.folder11.folder2
        # were not deleted.
        p_mkt = public.marketing
        rtv = p_mkt.restrictedTraverse
        self.failUnless(rtv('doc3', None))
        self.failUnless(rtv('folder1/folder11/folder2', None))
        self.failUnless(rtv('folder1/folder11/folder2/doc4', None))

    def testPersistentAttributePublishing(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        pubsite = self.portal.public_website
        mkt.setStagePath('public_website')
        from OFS.Folder import Folder as OFSFolder
        aFolder = makeContent(mkt, 'Folder', 'aFolder')
        aFolder.attrFolder = OFSFolder('attrFolder')
        aFolder.attrFolder.manage_afterAdd(aFolder.attrFolder, aFolder)
        aFolder.attrFolder.manage_addProduct['OFSP'].manage_addFolder('a')
        self.subcommit()
        mkt.publishStage('test1')
        self.failUnless('a' in pubsite.aFolder.attrFolder.objectIds())
        aFolder.attrFolder.manage_renameObject('a', 'b')
        # add object to destination to keep it from being wiped
        # during publication
        pubsite.aFolder.invokeFactory('Folder', 'aSubFolder')
        mkt.publishStage('test2')
        self.failIf('a' in pubsite.aFolder.attrFolder.objectIds())
        self.failUnless('b' in pubsite.aFolder.attrFolder.objectIds())

    def testNestingStagingTargets(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        adv = self.home.adv
        sales = self.home.sales
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Folder',id='folder1')
        mkt.publishStage('test1')
        # now we'll land adv content inside the published
        # area of mkt
        adv.setStagePath('public_website/folder1')
        adv.invokeFactory('Folder',id='folder11')
        # now we publish adv to see if everything went alright
        adv.publishStage('test2')
        dst_folder1 = self.public.folder1
        obIds = dst_folder1.objectIds()
        self.failIf('index_html' in obIds,
                    "stage reference found inside dest. folder1")
        self.failIf('folder11' not in obIds,
                    'folder11 not found inside dest. folder1')
        dst_folder11 = dst_folder1.folder11
        # and now we change mkt and publish to see if adv stuff survive
        mkt.invokeFactory('Folder',id='folder2')
        mkt.publishStage('test3')

        self.failUnless(self.public.restrictedTraverse('folder2',
                                                       None),
                        "folder2 wasn't published")
        dst_folder1 = self.public.folder1
        obIds = dst_folder1.objectIds()
        self.failIf('index_html' in obIds,
                    "stage reference found inside dest. folder1")
        self.failIf('folder11' not in obIds,
                    'folder11 not found inside dest. folder1')
        dst_folder11 = dst_folder1.folder11
        # and now we change adv once more and publish to see if there
        # really were no problems
        adv.folder11.invokeFactory('Folder', id='folder111')
        adv.invokeFactory('Folder', id='folder12')
        adv.publishStage('test4')

        dst_folder1 = self.public.folder1
        obIds = dst_folder1.objectIds()
        self.failIf('index_html' in obIds,
                    "stage reference found inside dest. folder1")
        self.failIf('folder11' not in obIds,
                    'folder11 not found inside dest. folder1')
        self.failIf('folder12' not in obIds,
                    'folder12 not found inside dest. folder1')
        dst_folder111 = dst_folder1.folder11.restrictedTraverse('folder111',
                                                                None)
        self.failUnless(dst_folder111, "folder111 wasn't published")
        dst_folder11 = dst_folder1.folder11
        # finally, let's try reverting mkt to a previous label
        mkt.updateStage(mkt._globalLabel('test1'))
        mkt.publishStage('test1back')
        # let's check we really went back first
        self.failIf(self.public.restrictedTraverse('folder2',
                                                   None),
                    "folder2 is still published")
        # finally let's see if adv stuff survived
        dst_folder1 = self.public.folder1
        obIds = dst_folder1.objectIds()
        self.failIf('index_html' in obIds,
                    "stage reference found inside dest. folder1")
        self.failIf('folder11' not in obIds,
                    'folder11 not found inside dest. folder1')
        self.failIf('folder12' not in obIds,
                    'folder12 not found inside dest. folder1')
        dst_folder111 = dst_folder1.folder11.restrictedTraverse('folder111',
                                                                None)
        self.failUnless(dst_folder111, "folder111 wasn't published")
        dst_folder11 = dst_folder1.folder11

    def testRenameAndRevert(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        adv = self.home.adv
        sales = self.home.sales
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Folder', 'afolder')
        mkt.afolder.invokeFactory('Document', 'doc1')
        # publish
        self.commit()
        mkt.publishStage(label='1')
        # rename and publish again
        self.commit()
        mkt.afolder.manage_renameObject('doc1', 'doc2')
        self.commit()
        mkt.publishStage(label='2')
        # check the target
        self.assertEquals(list(self.public.afolder.objectIds()),
                          ['doc2'])
        self.assertEquals(self.public.afolder.doc2.getId(), 'doc2')
        # revert and publish again
        mkt.updateStage(mkt._globalLabel('1'))
        mkt.publishStage(label='3')
        self.assertEquals(list(self.public.afolder.objectIds()),
                          ['doc1'])

    def testRenameAndRevertAfterIncremental(self):
        # same as before, but using incremental publish
        self.setupStagingAreas()
        mkt = self.home.mkt
        adv = self.home.adv
        sales = self.home.sales
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Folder', 'afolder')
        mkt.afolder.invokeFactory('Document', 'doc1')
        self.commit()
        # publish
        mkt.publishStage(label='1')
        # rename and publish again
        self.commit()
        mkt.afolder.manage_renameObject('doc1', 'doc2')
        self.commit()
        mkt.publishLastChanged(label='2')
        # check the target
        self.assertEquals(list(self.public.afolder.objectIds()),
                          ['doc2'])
        self.assertEquals(self.public.afolder.doc2.getId(), 'doc2')
        # revert and publish again
        mkt.updateStage(mkt._globalLabel('1'))
        mkt.publishStage(label='3')
        self.assertEquals(list(self.public.afolder.objectIds()),
                          ['doc1'])


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for testclass in (
        TestLabeling,
        ):
        suite.addTest(makeSuite(testclass))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
