# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

class DocTest(TestStaging):
    pass

def test_suite():
    from unittest import TestSuite, makeSuite
    from Testing.ZopeTestCase import FunctionalDocFileSuite
    suite = TestSuite()
    for klass, doctest in (
        (DocTest, 'labels.rst'),
        (DocTest, 'whitelist.rst'),
        (ZopeTestCase.FunctionalTestCase, 'events.rst'),
        ):
        suite.addTest(
            FunctionalDocFileSuite(doctest,
                                   package='Products.EnSimpleStaging.tests',
                                   test_class=klass,
                                   globs=globals()))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
