# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.tests.base import TestStaging

PloneTestCase.setupPloneSite()

from Products.EnSimpleStaging.Extensions.debugging import cleanUpESSLabels, _removeVersion

class TestCleanUp(TestStaging):

    def getReversibleAnnotations(self, stage):
        return [annotation for annotation in stage.getAnnotations()
                if stage.isReversibleAnnotation(annotation)]

    def testOnly3TagsLeft(self):
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Document', id='d1')
        mkt.invokeFactory('Document', id='d2')
        # publish the stage a first time
        mkt.publishStage('0')
        # lets gather some data about this publication
        annot0 = mkt.getLastAnnotation()
        label0 = annot0['args']['label']
        doc1VInfo = self.repo.getVersionInfo(mkt.d1)
        doc1histId = doc1VInfo.history_id
        doc1vers = doc1VInfo.version_id
        doc1vhistory = self.repo.getVersionHistory(doc1histId)
        doc2VInfo = self.repo.getVersionInfo(mkt.d2)
        doc2histId = doc2VInfo.history_id
        # let's check this annotation is reversible
        self.failUnless(mkt.isReversibleAnnotation(annot0))
        # now we delete d2
        mkt._delObject('d2')
        mkt.publishStage('1')
        # check that the hist. id for d1 is the same
        doc1VInfo1 = self.repo.getVersionInfo(mkt.d1)
        self.assertEquals(doc1histId, doc1VInfo1.history_id)
        # but not the version id
        self.assertNotEquals(doc1vers, doc1VInfo1.version_id)
        # now let's publish some more to make sure deployment 0 falls
        # out of the labels-to-keep range
        mkt.publishStage('2')
        mkt.publishStage('3')
        self.assertEquals(len(self.getReversibleAnnotations(mkt)), 4)
        self.failUnless(mkt.isReversibleAnnotation(annot0))
        cleanUpESSLabels(self.portal, StringIO())
        # let's check that there are less reversible annotations
        self.assertEquals(len(self.getReversibleAnnotations(mkt)), 3)
        # and that the first annotation is no longer reversible
        self.failIf(mkt.isReversibleAnnotation(mkt.getAnnotations()[0]),
                    "1st annotation is still reversible: %s" % mkt.getAnnotations()[0])
        # test if version histories in the repository still have this label
        self.failIf(label0 in doc1vhistory.getLabels())
##        # also check that the version was removed
##        doc1vhistory = self.repo.getVersionHistory(doc1histId)
##        self.failIf(doc1vers in doc1vhistory.getVersionIds())
        # check that the old version doesn't carry any data
        self.assertEquals(doc1vhistory.getVersionById(doc1vers)._data, None,
                          "data hasn't been removed from version")
        # no trace of the old d2 version history should've been left behind
        self.assertRaises(KeyError, self.repo.getVersionHistory, doc2histId)

    def x_test_removeVersion(self):
        d = makeContent(self.home, 'Document', 'doc')
        f = makeContent(self.home, 'Folder', 'f')
        self.repo.applyVersionControl(d)
        vInfo = self.repo.getVersionInfo(d)
        hist_id = vInfo.history_id
        vid0 = vInfo.version_id
        # check in a few times
        self.repo.checkoutResource(d)
        self.repo.checkinResource(d)
        vid1 = self.repo.getVersionInfo(d).version_id
        self.repo.checkoutResource(d)
        self.repo.checkinResource(d)
        vid2 = self.repo.getVersionInfo(d).version_id
        self.repo.checkoutResource(d)
        self.repo.checkinResource(d)
        vid3 = self.repo.getVersionInfo(d).version_id
        vids = (vid0, vid1, vid2, vid3)
        self.assertEquals(len(Set(vids)), 4,
                          "some version_ids are repeated %s" % (vids,))
        # now some sanity checks
        vhistory = self.repo.getVersionHistory(hist_id)
        vers = [vhistory.getVersionById(vid) for vid in vids]
        self.assertEquals(vers[0].prev, None)
        self.assertEquals(vers[3].next, ())
        for i, ver in enumerate(vers[:-1]):
            vid = vids[i]
            nextvid = vids[i+1]
            nextver = vers[i+1]
            # .prev should point to the previous version
            self.assertEquals(nextver.prev, vid,
                              "broken .prev link for version_id %s: %s" %
                              (nextvid, nextver.prev))
            # since we didn't have any branches, the .next tuple
            # should contain only the next version
            self.assertEquals(ver.next, (nextvid,),
                              "broken .next link for version_id %s: %s" %
                              (vid, ver.next))
        # now let's start chopping off versions
        # a guy in the middle
        _removeVersion(vid1, vhistory)
        self.assertEquals(vers[0].next, (vid2,))
        self.assertEquals(vers[2].prev, vid0)
        # a guy in the beginning
        _removeVersion(vid0, vhistory)
        self.assertEquals(vers[2].prev, None)
        # a guy in the end
        _removeVersion(vid3, vhistory)
        self.assertEquals(vers[2].next, ())
        # check that all that is left is version 2
        remaining = list(vhistory._versions.items())
        self.assertEquals(remaining, [ (vid2, vers[2].aq_base) ])

    def testUnchangedVersionStays(self):
        # test if versions that haven't changed are left after the cleanup
        # even if included in the cutoff labels
        self.setupStagingAreas()
        mkt = self.home.mkt
        mkt.setStagePath('public_website')
        mkt.invokeFactory('Document', id='d1')
        mkt.invokeFactory('Folder', id='f2')
        # publish the stage a first time
        mkt.publishStage('0')
        label0 = mkt.getLastAnnotation()['args']['label']
        doc1VInfo = self.repo.getVersionInfo(mkt.d1)
        doc1histId = doc1VInfo.history_id
        doc1vers = doc1VInfo.version_id
        # now let's do some partial publishings
        self.subcommit()
        import time
        time.sleep(1)
        mkt.f2.edit(title="title 1")
        mkt.publishLastChanged('1')
        label1 = mkt.getLastAnnotation()['args']['label']

        self.subcommit()
        import time
        time.sleep(1)
        mkt.f2.edit(title="title 2")
        mkt.publishLastChanged('2')
        label2 = mkt.getLastAnnotation()['args']['label']

        self.subcommit()
        import time
        time.sleep(1)
        mkt.f2.edit(title="title 3")
        mkt.publishLastChanged('3')
        label3 = mkt.getLastAnnotation()['args']['label']
        # now we cleanup old deployments.
        cleanUpESSLabels(self.portal, StringIO())
        # and check things worked out
        doc1VInfo = self.repo.getVersionInfo(mkt.d1)
        doc1histId = doc1VInfo.history_id
        doc1vers = doc1VInfo.version_id
        # this shouldn't fail
        doc1vhistory = self.repo.getVersionHistory(doc1histId)
        # check the stored info matches
        relpath = self.wt.getRelativeStageURL(mkt.d1)
        s_info = self.wt._stage_info[mkt._getSourceStageName()]
        pathInfo = s_info[label3].traverse(relpath)
        self.assertEquals((doc1histId, doc1vers),
                          (pathInfo.info.history_id, pathInfo.info.version_id))

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for testclass in (
        TestCleanUp,
        ):
        suite.addTest(makeSuite(testclass))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
