# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import os, sys
from sets import Set

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase.functional import Functional
from Products.PloneTestCase import PloneTestCase

for product in ('Archetypes',
                'PortalTransforms',
                'ZopeVersionControl',
                'CMFStaging',
                'EnSimpleStaging',
                'MimetypesRegistry',
                'PluggableDiscussion',
#                'StageDeployment',
#                'SecureMailHost',
                ):
    PloneTestCase.installProduct(product)
del product

PloneTestCase.setupPloneSite()

from cStringIO import StringIO
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.tests.utils import makeContent
from Products.EnSimpleStaging.Extensions.Install import setup_local_tools

class TestStaging(PloneTestCase.PloneTestCase):

    P_COUNT = 13

    #  \index_html
    #  \doc1
    #  \folder1
    #     \folder11
    #     \folder12
    #     \doc11
    #  \folder2
    #     \folder21
    #     \doc21
    #     \index_html
    #     \folder22
    #        \folder221
    #           \doc2211

    _defaultStructure = [dict(id='index_html', type='Document'),
                         dict(id='doc1', type='Document'),
                         dict(id='folder1', type='Folder',
                              objs=[dict(id='doc11', type='Document'),
                                    dict(id='folder11', type='Folder'),
                                    dict(id='folder12', type='Folder'),
                                    ]),
                         dict(id='folder2', type='Folder',
                              objs=[dict(id='index_html', type='Document'),
                                    dict(id='doc21', type='Document'),
                                    dict(id='folder21', type='Folder'),
                                    dict(id='folder22', type='Folder',
                                         objs=[dict(id='folder221',
                                                    type='Folder',
                                                    objs=[dict(id='doc2211',
                                                               type='Document')]),
                                               ]),
                                    ]),
                         ]

    def _populateFolder(self, folder, structure=_defaultStructure):
        for item in structure:
            obj = makeContent(folder, item['type'], id=item['id'])
            self._populateFolder(obj, structure=item.get('objs', []))

    def _checkStructure(self, folder, structure=_defaultStructure,
                        path='', errors=None):
        if errors is None:
            errors = {}
        for item in structure:
            if item['id'] not in folder.objectIds():
                errors.setdefault(path, []).append((item['id'], 'NotFound'))
                continue
            obj = folder[item['id']]
            if obj.portal_type != item['type']:
                errors.setdefault(path, []).append((item, obj.portal_type,
                                                    'BadType'))
            self._checkStructure(obj, structure=item.get('objs', []),
                                 path=path + '/' + item['id'], errors=errors)
        return errors

    def afterSetUp(self):
        PloneTestCase.PloneTestCase.afterSetUp(self)
        self.loginAsPortalOwner()
        self.qi = self.portal.portal_quickinstaller
        self.qi.installProduct('EnSimpleStaging')
        self.mt = self.portal.portal_membership
        self.wt = self.portal.portal_workspaces
        self.vt = self.portal.portal_versions
        self.acl_users = self.portal.acl_users
        self.repo = self.portal.VersionRepository
        home = self.mt.getHomeFolder()
        if home is None:
            # Plone 2.1
            member_id = self.mt.getAuthenticatedMember().getId()
            home = makeContent(self.portal.Members, 'Folder', id=member_id)
        self.home = home
        self.ct = self.portal.portal_catalog
        if 'public_website' in self.portal.objectIds():
            # XXX Bad thing
            self.portal.manage_delObjects(['public_website'])
        self.public = makeContent(self.portal, 'Folder', id='public_website')
        self.fixCatalog()
        self.setupSkin()

    def fixCatalog(self):
        # make sure we get a FieldIndex for 'modified' or our tests will get
        # in trouble (we'd have to pause some tests for up to 1 minute to
        # make them pass otherwise.
        # If we manage to not depend on the catalog for partial publishing
        # we can get rid of this.
        self.ct.delIndex('modified')
        self.ct.addIndex('modified', 'FieldIndex')
        self.ct.reindexIndex('modified', self.app.REQUEST)

    def beforeTearDown(self):
        self.maybeRelease()
        PloneTestCase.PloneTestCase.beforeTearDown(self)

    _checkpoint = None
    _checkpoint_batch = 10

    def maybeMark(self):
        if self._checkpoint is not None:
            # already marked
            return
        import random
        checkpoint = "CHECKPOINT(%X)" % random.randint(0, sys.maxint)
        self._checkpoint = checkpoint
        get_transaction().note(checkpoint)

    def maybeRelease(self):
        checkpoint = self._checkpoint
        if checkpoint is None:
            # nothing to undo
            return
        transaction_list = self.app.undoable_transactions(
            PrincipiaUndoBatchSize=100)
        transaction_ids = []
        for transaction in transaction_list:
            transaction_ids.append(transaction['id'])
            if checkpoint in transaction['description']:
                break
        else:
            raise ValueError("No checkpoint transaction found")
        self.app.manage_undo_transactions(transaction_ids)
        return checkpoint

    def setupSkin(self):
        if hasattr(self.portal, 'clearCurrentSkin'):
            # CMF 1.5
            self.portal.clearCurrentSkin()
        else:
            # CMF 1.4
            self.portal._v_skindata = None
        self.portal.setupCurrentSkin()

    def subcommit(self):
        get_transaction().commit(1)
        # subcommiting causes the portal to be ghosted
        # we need to re-setup the skin
        self.setupSkin()

    def commit(self):
        self.maybeMark()
        self._checkpoint_batch = self._checkpoint_batch + 1
        get_transaction().note("commited by unittest")
        get_transaction().commit()
        # commiting causes the portal to be ghosted
        # we need to re-setup the skin
        self.setupSkin()

    def setupStagingAreas(self):
        for area in 'mkt adv sales'.split():
            if area in self.home.objectIds():
                self.home.manage_delObjects([area])
            areaTitle = area + ' staging area'
            self.home.invokeFactory('StagingArea', area, title=areaTitle)

    def setupNestedSite(self):
        setup_local_tools(self.portal, StringIO())
