##parameters=IncrementalDeployment=False, label=None, comment='', queued=False
from Products.PythonScripts.standard import urlencode

request=context.REQUEST
response=request.RESPONSE

url = '%s/workspace_deployment' % context.absolute_url()

catalog = context.portal_catalog
def processQueueCatalog():
    process = getattr(catalog, 'process', None)
    if process:
        items = catalog.getIndexInfo()
        process(len(items))

if label is None:
    label = context.getNextLabel()    

labels = [info.get('label', '').strip() for info in context.getAnnotations()]

processQueueCatalog()

if label.strip() in labels:
    msg = ('The label, %s has already been used.  '
           'Please select another.' % str(label))
else:
    if queued:
        msg = "Queued "
    else:
        msg = "Completed "
    if IncrementalDeployment:
        context.publishLastChanged(label=label, message=comment, queued=queued)
        msg += 'Incremental'
    else:
        context.publishStage(label=label, message=comment, queued=queued)
        msg += 'Full'
    msg += " Deployment of " + context.title_or_id()

processQueueCatalog()

query = "?" + urlencode(dict(portal_status_message=msg))
response.redirect(url + query)
return url + query
