## Script (Python) "gs_ToBeReviewed"
##parameters=max_entries=10,last_login_time=None,state=None

""" This script is meant to be executed by a PageTemplate
    in the context of a Workgroup Stage """

catalog = context.portal_catalog
urltool = context.portal_url
workspace = context
portal=urltool.getPortalObject()
state = state or 'pending'
getTransitionsFor = context.portal_workflow.getTransitionsFor

relative_path = '/'.join(portal.getPhysicalPath()) + '/'+ \
                urltool.getRelativeContentURL(context)

results = []
x = 0

for result in catalog(path = relative_path,
                      review_state=state,
                      sort_on ='created',
                      sort_order = 'reverse'):

    results.append( {'URL':result.getURL(),
                     'Creator':result.Creator,
                     'Title':result.Title,
                     'Description':result.Description,
                     'Date':result.Date,
                     'ModificationDate':result.ModificationDate,
                     'CreationDate':result.CreationDate,
                     'review_state':result.review_state,
                     'transitions':getTransitionsFor(result.getObject()),
                     'getIcon':result.getIcon,
                     'brain':result} )
    x += 1
    if x == max_entries:
        break

response = { 'Title':'Content Pending Review',
             'Description':'',
             'results':results }

return response
