## Script (Python) "gs_ModifiedSinceLastLogin"
##parameters=max_entries=10,last_login_time=None

""" This script is meant to be executed by a PageTemplate
    in the context of a Workgroup Stage """

if last_login_time is None:
    member = context.portal_membership.getAuthenticatedMember()
    last_login_time = member.getProperty('last_login_time')

catalog = context.portal_catalog
urltool = context.portal_url
workspace = context
portal=urltool.getPortalObject()

relative_path = '/'.join(portal.getPhysicalPath()) + '/'+ \
                urltool.getRelativeContentURL(context)

results = []
x = 0

for result in catalog(path = relative_path,
                      #modified = {'query':last_login_time, 'range': 'min'},
                      sort_on='modified',
                      sort_order='reverse'):

    # Skip objects that do not have meaningful ModificationDates
    # or objects that are not of value to this query

    #if result.CreationDate == result.ModificationDate:
    #    continue

    if result.meta_type in ['Public Site Node', 'Private Sandbox']:
        continue

    if result.portal_type in ['Discussion Item']:
        continue

    if result.getURL().find('portal_factory') > -1:
        continue

    if result.getURL().find('cp_container') > -1:
        continue

    title = result.Title and result.Title.strip() or ''
    results.append( {'URL':result.getURL(),
                     'Creator':result.Creator,
                     'Title':title,
                     'Description':result.Description,
                     'Date':result.Date,
                     'ModificationDate':result.ModificationDate,
                     'CreationDate':result.CreationDate,
                     'review_state':result.review_state,
                     'getIcon':result.getIcon,
                     'getId':result.getId} )

    x += 1
    if x == max_entries:
        break

response = { 'Title':'Recently Modified',
             'Description':'',
             'results':results }

return response
