## Script (Python) "gs_WorkgroupCommentsSinceLastLogin"
##parameters=max_entries=10,last_login_time=None

""" This script is meant to be executed by a PageTemplate
    in the context of a Workgroup Stage """


if last_login_time is None:
    member = context.portal_membership.getAuthenticatedMember()
    last_login_time = member.getProperty('last_login_time')

catalog = context.portal_catalog
urltool = context.portal_url
workspace = context
portal=urltool.getPortalObject()
portal_url=urltool()

relative_path = '/'.join(portal.getPhysicalPath()) + '/'+ \
                urltool.getRelativeContentURL(context)

results = []
x = 0

for result in catalog(path = relative_path,
                      portal_type = 'Discussion Item',
                      sort_on='modified',
                      sort_order='reverse'):

    result_url = result.getURL()
    reply_to = result_url.split('/talkback')[0][len(portal_url)+1:] #XXX Policy dependent

    results.append( {'URL':result_url,
                     'Creator':result.Creator,
                     'Title':result.Title,
                     'Description':result.Description,
                     'Date':result.Date,
                     'ModificationDate':result.ModificationDate,
                     'CreationDate':result.CreationDate,
                     'review_state':result.review_state,
                     'getIcon':result.getIcon,
                     'reply_to':portal.restrictedTraverse(reply_to, None)
                     } )

    x += 1
    if x == max_entries:
        break

response = { 'Title':'Group Comments',
             'Description':'',
             'results':results }

return response
