## Script (Python) "ess_getLastChangedPathsSince"
##parameters=date,query=None
""" This script is meant to be executed by the stage in it's own context
"""
from Products.CMFCore.utils import getToolByName

if query is None:
    query = {}

stage_path = "/".join(context.getPhysicalPath())
ct = getToolByName(context, 'portal_catalog')
query.update(dict(path=stage_path,
                  modified=dict(query=date,
                                range='min')))

brains = ct(**query)
paths = [brain.getPath() for brain in brains
         # avoid the stage itself
         if brain.getPath() != stage_path
         # avoid CompositePack attributes and its subobjects.
         and 'cp_container' not in brain.getPath()
         # avoid portal_factory leftovers
         and 'portal_factory' not in brain.getPath()
         ]

return paths
