# EnSimpleStaging  |  Copyright(C), 2006, Enfold Systems, LLC
# see LICENSE.txt for details

from Acquisition import aq_parent

from OFS.ObjectManager import ObjectManager
from OFS.CopySupport import CopySource

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CatalogTool import CatalogTool
from Products.CMFCore.PortalFolder import PortalFolderBase
from Products.CMFCore.TypesTool import FactoryTypeInformation
from Products.CMFPlone.PloneFolder import OrderedContainer

from Products.Archetypes.exceptions import ReferenceException
from Products.Archetypes.utils import shasattr
from Products.Archetypes.ReferenceEngine import Reference
from Products.Archetypes.OrderedBaseFolder \
     import OrderedContainer as ATOrderedContainer
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2Base

from Products.EnSimpleStaging.config import logger
from Products.EnSimpleStaging.event import subscribe
from Products.EnSimpleStaging.interfaces import IObjectStagedEvent

def log(msg):
    logger.info(msg)

PATTERN = '__EnSimpleStaging_%s__'
def call(self, __name__, *args, **kw):
    return getattr(self, PATTERN % __name__)(*args, **kw)

WRAPPER = '__ensimplestaging_is_wrapper_method__'
ORIG_NAME = '__ensimplestaging_original_method_name__'
def isWrapperMethod(meth):
    return getattr(meth, WRAPPER, False)

def patch_nonversionables():
    from Products.CompositePack.composite import packcomposite
    from Products.CompositePack.composite import archetype
    klasses = [packcomposite.PackSlotCollection,
               packcomposite.PackTitleCollection,
               packcomposite.PackComposite,
               packcomposite.PackSlot,
               archetype.Element]
    for klass in klasses:
        klass.__non_versionable__ = 1
    log(('Patching CompositePack class definitions '
         'to make them non_versionable for ZVC'))

def wrap_method(klass, name, method, pattern=PATTERN):
    old_method = getattr(klass, name)
    if isWrapperMethod(old_method):
        # Double-wrapping considered harmful.
        log('Already wrapped method %s.%s, skipping.' %
            (klass.__name__, name))
        return
    log('Wrapping method %s.%s' % (klass.__name__, name))
    new_name = pattern % name
    setattr(klass, new_name, old_method)
    setattr(method, ORIG_NAME, new_name)
    setattr(method, WRAPPER, True)
    setattr(klass, name, method)

def unwrap_method(klass, name):
    old_method = getattr(klass, name)
    if not isWrapperMethod(old_method):
        raise ValueError, ('Trying to unwrap non-wrapped '
                           'method %s.%s' % (klass.__name__, name))
    orig_name = getattr(old_method, ORIG_NAME)
    new_method = getattr(klass, orig_name)
    delattr(klass, orig_name)
    setattr(klass, name, new_method)

def maybeReindex(obj):
    if isinstance(obj, CatalogTool):
        # Ignore as it has a different API for reindexObject
        return
    if getattr(obj, 'ESS_INSTALLING_LOCAL_TOOLS', False):
        # see Install.py, setup_local_tools()
        # catalogs are not yet in place
        return
    if shasattr(obj, 'notifyModified'):
        obj.notifyModified()
    if shasattr(obj, 'reindexObject'):
        obj.reindexObject(idxs=['modified'])

def delHook(self, tool, sourceObject=None, targetObject=None):
    wt = getToolByName(self, 'portal_workspaces')
    if ((sourceObject and wt._isProtectedUID(sourceObject.UID())) or
        (targetObject and wt._isProtectedUID(targetObject.UID()))):
        raise ReferenceException('This UID will come back on deployment')
    return call(self, 'delHook', tool, sourceObject, targetObject)

def _setOb(self, *args, **kw):
    ret = call(self, '_setOb', *args, **kw)
    maybeReindex(self)
    return ret

def _delOb(self, *args, **kw):
    ret = call(self, '_delOb', *args, **kw)
    maybeReindex(self)
    return ret

def _postCopy(self, *args, **kw):
    ret = call(self, '_postCopy', *args, **kw)
    maybeReindex(self)
    return ret

def moveObject(self, *args, **kw):
    ret = call(self, 'moveObject', *args, **kw)
    maybeReindex(self)
    return ret

def moveObjectsByDelta(self, *args, **kw):
    ret = call(self, 'moveObjectsByDelta', *args, **kw)
    maybeReindex(self)
    return ret

def allowedContentTypes(self):
    """Monkeypatch over PortalFolder to filter out content types that
    are not whitelisted on an the ESS workspace, if this object is
    inside one.

    Original docstring:
    List type info objects for types which can be added in
    this folder.
    """
    ret = call(self, 'allowedContentTypes')
    nofilter = lambda subtypes: subtypes
    # ess_filterWhitelistedTypes will be retrieved by acquisition from
    # ESS workspaces. See EnSimpleStaging/content/stage.py
    whitelist_method = getattr(self, 'ess_filterWhitelistedTypes', nofilter)
    ret = whitelist_method(ret)

    return ret

def isConstructionAllowed( self, container ):
    """MonkeyPatch over FactoryTypeInformation to disallow
    construction if the EnSimpleStaging wokspace forbids it.
    Original docstring:

    a. Does the factory method exist?

    b. Is the factory method usable?

    c. Does the current user have the permission required in
    order to invoke the factory method?
    """
    typename = self.getId()
    ret = call(self, 'isConstructionAllowed', container)

    nofilter = lambda subtypes: subtypes
    # ess_filterWhitelistedTypes will be retrieved by acquisition from
    # ESS workspaces. See EnSimpleStaging/content/stage.py
    whitelist_method = getattr(container, 'ess_filterWhitelistedTypes', nofilter)

    # if the whitelist filters out this type, block construction
    if not whitelist_method([self]):
        return False

    return ret

# This subscriber is used for marking the composable object as changed
# when something inside it changes (eg, the slots or composite
# elements).
def compositeChangeSubscriber(event):
    from OFS.event import ObjectWillBeAddedEvent

    ob = event.object
    if ob._p_jar is None or isinstance(event, ObjectWillBeAddedEvent):
        return None

    if 'cp_container' in ob.getPhysicalPath():
        page = ob
        while page is not None:
            if shasattr(page, 'cp_container'):
                page.notifyModified()
                page.reindexObject()
                break
            page = aq_parent(page)

# This subscriber is used for reindexing the reference objects inside
# a composable object. It only matters if you are using CompositePack.
def compositeStagingSubscriber(event):
    if not IObjectStagedEvent.isImplementedBy(event):
        return
    target = event.target
    if not shasattr(target, 'cp_container'):
        # Not a Composable Object
        return
    composite = target.cp_container
    ct = getToolByName(composite, 'portal_catalog')
    def do_reindex(item, path):
        item._updateCatalog(aq_parent(item))
        # does nothing it seems, looks like intentionally disabled.
        # item.reindexObject()

    # Find all CompositePack Elements inside the Composite
    # and call do_reindex on them to reindex the Reference objects.
    ct.ZopeFindAndApply(composite, obj_metatypes=('CompositePack Element',),
                        search_sub=1, apply_func=do_reindex)

subscribe(IObjectStagedEvent, compositeStagingSubscriber)

wrap_method(Reference, 'delHook',
            delHook, pattern=PATTERN)

wrap_method(ObjectManager, '_setOb',
            _setOb, pattern=PATTERN)

wrap_method(ObjectManager, '_delOb',
            _delOb, pattern=PATTERN)

wrap_method(BTreeFolder2Base, '_setOb',
            _setOb, pattern=PATTERN)

wrap_method(BTreeFolder2Base, '_delOb',
            _delOb, pattern=PATTERN)

wrap_method(CopySource, '_postCopy',
            _postCopy, pattern=PATTERN)

wrap_method(OrderedContainer, 'moveObject',
            moveObject, pattern=PATTERN)

wrap_method(OrderedContainer, 'moveObjectsByDelta',
            moveObjectsByDelta, pattern=PATTERN)

wrap_method(ATOrderedContainer, 'moveObject',
            moveObject, pattern=PATTERN)

wrap_method(ATOrderedContainer, 'moveObjectsByDelta',
            moveObjectsByDelta, pattern=PATTERN)

wrap_method(PortalFolderBase, 'allowedContentTypes',
            allowedContentTypes, pattern=PATTERN)

wrap_method(FactoryTypeInformation, 'isConstructionAllowed',
            isConstructionAllowed, pattern=PATTERN)

try:
    patch_nonversionables()
except ImportError:
    pass
