# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from zope.interface import implements, Interface, Attribute

class IInPlaceStaging(Interface):
    """Marker interface for in-place staging
    """

class IEvent(Interface):
    """Base Event Interface
    """

class IObjectStagedEvent(IEvent):
    """Notify the framework about the staging of an object.
    """

    source = Attribute('Source object being staged')
    target = Attribute('Target object being staged')
    full = Attribute('Is it part of a full or partial deployment?')

class ObjectStagedEvent:

    implements(IObjectStagedEvent)

    def __init__(self, source, target, full):
        self.source = source
        self.target = target
        self.full = full

def staged(source, target, full):
    from Products.EnSimpleStaging.event import publish
    publish(ObjectStagedEvent(source, target, full))
