# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

import sets
from types import InstanceType, ListType, TupleType
from zope.interface import providedBy

def dotted(iface):
    return '%s.%s' % (iface.__module__,
                      iface.__name__)

class Subscriber:

    def __init__(self, name, title, subscriber, _for):
        self.name = name
        if not title:
            title = name
        self.title = title
        self.subscriber = subscriber
        self._for = _for

    def info(self):
        return {'name':self.name,
                'title':self.title}

    def __call__(self, *args, **kw):
        return self.subscriber(*args, **kw)

    def __hash__(self):
        return hash((self._for, self.subscriber))

    def __cmp__(self, other):
        if not isinstance(other, self.__class__):
            raise TypeError, 'Cannot compare different types'
        return cmp(hash(self), hash(other))

    def __repr__(self):
        return '<subscriber %s for %s>' % (self.name, dotted(self._for))

subscriber_registry = {}

def subscribe(iface, subscriber, name=None, title=None):
    from Products.EnSimpleStaging.interfaces import IEvent
    if not issubclass(iface, IEvent):
        raise TypeError, '%s is not an IEvent' % dotted(iface)
    if name is None:
        base = subscriber
        if type(subscriber) in (InstanceType,):
            base = subscriber.__class__
        name = base.__name__
    if not title:
        title = name
    subscribers = subscriber_registry.setdefault(iface, sets.Set())
    sub = Subscriber(name=name, title=title,
                     subscriber=subscriber,
                     _for=iface)
    subscribers.add(sub)

def subscribers(iface):
    return iter(subscriber_registry.get(iface, []))

def flatten(spec, seen=None):
    if seen is None:
        seen = []
    for iface in spec.interfaces():
        if not iface in seen:
            seen.append(iface)
        if iface is not spec:
            flatten(iface, seen)
        for base in iface.getBases():
            flatten(base, seen)
    return seen

def publish(event):
    for iface in flatten(providedBy(event)):
        for sub in subscribers(iface):
            sub(event)

def clear():
    subscriber_registry.clear()
