# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from Products.Archetypes.public import *
from Products.Archetypes.Referenceable import Referenceable
from Products.CMFCore.utils import getToolByName
from Products.EnSimpleStaging.config import PROJECTNAME

from stage import StagingArea
stage_type = StagingArea.portal_type

RefSchema = Schema((StringField('reference_uid',
                                vocabulary='_referencedStages',
                                widget=SelectionWidget()),))

class InterStageReference(BaseContent):
    portal_type = 'InterStageReference'
    meta_type = archetype_name = 'Interstage Reference'
    schema = BaseContent.schema + RefSchema

    def _referencedStagesData(self):
        pcatalog = getToolByName(self, 'portal_catalog')
        stages = [o.getObject() for o in pcatalog(portal_type=stage_type)]
        references = [(o.UID(), "%s (%s)" % (o.Title(),
                                           "/".join(o.getPhysicalPath())))
                       for o in stages ]
        return references

    def _referencedStages(self):
        return DisplayList(self._referencedStagesData())

#registerType(InterStageReference)
