# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from zLOG import LOG, INFO, DEBUG, BLATHER

PROJECTNAME = 'EnSimpleStaging'
ADD_CONTENT_PERMISSION = 'EnSimpleStaging: Add content'
GLOBALS = globals()
# dependencies that should be quick-installed
DEPENDENCIES = [
##  'PluggableDiscussion',
                ]
# tools provided by this Product
# [ ( 'tool_id', 'Tool Name' ), ... ]
# would be nice if we took this info from the tool classes
# themselves.
TOOLS = [('portal_workspaces', 'Workspaces Tool'),
         ('portal_versions', 'Versioning Tool'),
         ('portal_lock', 'Locking Tool')]

class Logger:

    def log(self, msg, **kw):
        level = kw.get('level', BLATHER)
        LOG(PROJECTNAME, level, msg)

    def debug(self, msg, **kw):
        kw['level'] = DEBUG
        self.log(msg, **kw)

    def info(self, msg, **kw):
        kw['level'] = INFO
        self.log(msg, **kw)

logger = Logger()

import os
WWWDIR = os.path.join(os.path.dirname(__file__), 'www')
del os
