# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from Products.Archetypes.public import registerClasses, process_types
from Products.Archetypes import listTypes
from Products.CMFCore import utils as cmf_utils
from Products.CMFCore.DirectoryView import registerDirectory
try:
    from Products.CMFPlone.utils import ToolInit
except ImportError:
    from Products.CMFPlone.PloneUtilities import ToolInit
import zLOG

from config import *
from tools.workspaces import StagingError

# monkeypatches
import patch

# This checks the install method is importable
from Extensions.Install import install as xInstall
del xInstall

registerDirectory('skins', globals())

def initialize(context):

    #from content import stage, reference
    from content import stage

    # register archetypes content with the machinery
    types = listTypes(PROJECTNAME)
    content_types, constructors, ftis = process_types(types, PROJECTNAME)
    cmf_utils.ContentInit(
        PROJECTNAME + ' Content',
        content_types = content_types,
        permission = ADD_CONTENT_PERMISSION,
        extra_constructors = constructors,
        fti = ftis).initialize(context)

    registerClasses(context, PROJECTNAME, ['Simple Staging Areas'])

    from tools import workspaces, locking, versioning

    tools = (workspaces.WorkspacesTool, locking.LockingTool,
             versioning.VersioningTool)
    try:
        ToolInit(PROJECTNAME + ' Tools',
                 tools=tools,
                 icon='tool.gif',
                 ).initialize(context)
    except TypeError:
        # Older CMF
        ToolInit(PROJECTNAME + ' Tools',
                 product_name='EnSimpleStaging',
                 tools=tools,
                 icon='tool.gif',
                 ).initialize(context)
