# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from Products.CMFCore.utils import getToolByName
from Products.EnSimpleStaging.Extensions.Install import install_vc
from cStringIO import StringIO

import zLOG

def removeVersionInfo(obj, path=None):
    # to be used with ZopeFindAndApply
    try:
        del obj.__vc_info__
    except (AttributeError, KeyError): # KeyError?! ExtensionClass is nuts...
        pass

def myLog(msg):
    zLOG.LOG("EnSimpleStaging::resetStages", zLOG.INFO, msg)

def resetWorkspaces(self, log=myLog):
    out = StringIO()
    log("starting stages reset!!")
    log("removing VersionRepository")
    self.manage_delObjects(['VersionRepository'])
    log("readding VersionRepository")
    install_vc(self, out)
    log("resetting tagging information on portal_workspaces")
    wt = getToolByName(self, 'portal_workspaces')
    wt.__init__()
    log("starting reset of individual workspaces:")
    ct = getToolByName(self, 'portal_catalog')
    workspacesToDeploy = []
    for brain in ct(portal_type='StagingArea'):
        workspace = brain.getObject()
        log("-- resetting workspace %s" % brain.getPath())
        # remove version information from all objects in the workspace
        log("---- removing versioning info from objects")
        ct.ZopeFindAndApply(workspace, search_sub=1, apply_func=removeVersionInfo)
        log("---- resetting annotation information from workspace")
        needsDeployment = False
        spath = workspace.getStagePath()
        if spath and wt.getStagesInfo().get(spath):
            # workspace has a valid target
            for annot in workspace.getAnnotations():
                if 'tag' in annot['operation']:
                    # this workspace has been published before so we'll redeploy it
                    workspacesToDeploy.append((spath.split('/'), workspace))
                    break
        # now, we reset the annotations
        workspace._resetAnnotations()
        log("-- done resetting workspace %s" % brain.getPath())
    # sort workspaces by their destination path so that we deploy them
    # in the right order (containers first)
    log("starting deployment of needed workspaces:")
    workspacesToDeploy.sort()
    for spath, workspace in workspacesToDeploy:
        log("-- deploying workspace %s to %s" % ('/'.join(workspace.getPhysicalPath()), '/'.join(spath)) )
        # deploy workspaces with full cleanup
        workspace.publishStage(label=workspace.getNextLabel(),
                               message='initial deployment after reset', hardWipe=True)

    log("finished stages reset!!")
