# EnSimpleStaging  |  Copyright(C), 2005, Enfold Systems, LLC
# see LICENSE.txt for details
#
# This file contains code Copyright (c) Zope Corporation and Contributors
# (getPickleSize)
##############################################################################
#
# Copyright (c) 2001 Zope Corporation and Contributors. All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################
#
# This file contains code Copyright (c) Python Software Foundation
# (NullStringIO)

import tempfile
import time
from cPickle import Pickler, Unpickler

from OFS.SimpleItem import SimpleItem

def getPickleSize(obj, ignore_list=()):
    """Makes a copy of a ZODB object, loading ghosts as needed.

    Ignores specified objects along the way, replacing them with None
    in the copy.
    """
    ignore_dict = {}
    for o in ignore_list:
        ignore_dict[id(o)] = o

    def persistent_id(ob, ignore_dict=ignore_dict):
        if ignore_dict.has_key(id(ob)):
            return 'ignored'
        if getattr(ob, '_p_changed', 0) is None:
            ob._p_changed = 0
        return None

    def persistent_load(ref):
        assert ref == 'ignored'
        # Return a placeholder object that will be replaced by
        # removeNonVersionedData().
        placeholder = SimpleItem()
        placeholder.id = "ignored_subobject"
        return placeholder

    stream = NullIO()
    p = Pickler(stream, 1)
    p.persistent_id = persistent_id
    p.dump(obj)
    return stream.tell()

try:
    from errno import EINVAL
except ImportError:
    EINVAL = 22

class NullIO:
    """class NullIO([buffer]) """

    def __init__(self, buf = ''):
        buf = self._stringify(buf)
        self.len = len(buf)
        self.pos = 0
        self.closed = 0
        self.softspace = 0

    def _stringify(self, buf):
        # Force self.buf to be a string or unicode
        if not isinstance(buf, basestring):
            buf = str(buf)
        return buf

    def _checkNotClosed(self):
        if self.closed:
            raise ValueError, "I/O operation on closed file"

    def close(self):
        """Free the memory buffer.
        """
        if not self.closed:
            self.closed = 1
        del self.pos

    def isatty(self):
        self._checkNotClosed()
        return False

    def seek(self, pos, mode = 0):
        self._checkNotClosed()
        if mode == 1:
            pos += self.pos
        elif mode == 2:
            pos += self.len
        self.pos = max(0, pos)

    def tell(self):
        self._checkNotClosed()
        return self.pos

    def read(self, n=-1):
        self._checkNotClosed()
        raise IOError(EINVAL, "this is a write-only stream")

    def readline(self, length=None):
        self._checkNotClosed()
        raise IOError(EINVAL, "this is a write-only stream")

    def readlines(self, sizehint=0):
        self._checkNotClosed()
        raise IOError(EINVAL, "this is a write-only stream")

    def truncate(self, size=None):
        self._checkNotClosed()
        if size is None:
            size = self.pos
        elif size < 0:
            raise IOError(EINVAL, "Negative size not allowed")
        elif size < self.pos:
            self.pos = size

    def write(self, s):
        self._checkNotClosed()
        if not s: return
        # Force s to be a string or unicode
        s = self._stringify(s)
        if self.pos == self.len:
            self.len = self.pos = self.pos + len(s)
            return
        if self.pos > self.len:
            self.len = self.pos
        newpos = self.pos + len(s)
        if self.pos < self.len:
            if newpos > self.len:
                self.len = newpos
        else:
            self.len = newpos
        self.pos = newpos

    def writelines(self, list):
        self.write(''.join(list))

    def flush(self):
        self._checkNotClosed()

from Products.CMFCore.utils import getToolByName
from sets import Set

def _removeVersion(version_id, versionHistory):
    version = versionHistory.getVersionById(version_id)
    # remove the version
    del versionHistory._versions[version_id]
    # fix the previous guy's .next link
    if version.prev:
        pversion = versionHistory.getVersionById(version.prev)
        assert len(pversion.next) < 2 # can't deal with branches
        if not version.next:
            # leave it for the class variable
            del pversion.next
        else:
            pversion.next = version.next
    # fix the next guy's .prev link
    if version.next:
        assert len(version.next) == 1 # can't deal with branches
        nversion = versionHistory.getVersionById(version.next[0])
        if not version.prev:
            # leave it for the class variable
            del nversion.prev
        else:
            nversion.prev = version.prev

def _reduceVersion(version_id, versionHistory):
    version = versionHistory.getVersionById(version_id)
    version._data = None

class Commiter:

    def __init__(self, every=1000):
        self.count = self.every = every

    def flag(self, out):
        self.count -= 1
        if not self.count:
            get_transaction().commit(1)
            self.count = self.every
            print >> out, "!",
        else:
            print >> out, ".",

def recursiveCollectVersions(pathInfo, versionset):
    if not pathInfo:
        return
    version_info = pathInfo.info
    # the version_info for the root of a stage is usually None
    # as it's not version controlled
    if version_info is not None:
        versionset.add( (version_info.history_id, version_info.version_id) )
    for subPathInfo in pathInfo.values():
        recursiveCollectVersions(subPathInfo, versionset)

def cleanUpESSLabels(self, out, leave=3):
    # select all ESS labels for this portal that we want to eliminate
    wt = getToolByName(self, 'portal_workspaces')
    remove_labels = Set()
    preserve_stages = Set()
    keep_versions = Set()
    for workspace in wt.getWorkspaces():
        # get some tagging labels except the ones we need to leave behind
        arg_labels = [annotation['args']['label']
                      for annotation in workspace.getAnnotations()
                      if workspace.isReversibleAnnotation(annotation)][:-leave]
        remove_labels |= Set(arg_labels)
        st_name, st_title, st_path = workspace.getSourceStageInfo()
        preserve_stages.add(st_name)
    # do a little cleanup in the workspace tool
    for stagename in list(wt._stage_info.keys()):
        # first we eliminate data about non-existant stages
        if stagename not in preserve_stages:
            del wt._stage_info[stagename]
            continue
        # then we eliminate data about removed labels
        # making them irreversible
        st_info = wt._stage_info[stagename]
        for label in list(st_info.keys()):
            if label in remove_labels:
                del st_info[label]
                continue
            # finally, collect the versions to preserve
            deployment = st_info[label]
            recursiveCollectVersions(deployment, keep_versions)
    # now we eliminate the all the labels from the VersionRepository
    # as we won't need them anymore.
    for label in list(self.VersionRepository._labels.keys()):
        del self.VersionRepository._labels[label]
    get_transaction().commit(1)
    # now we look at all version histories
    commiter = Commiter()
    for histid, vhistory in list(self.VersionRepository._histories.items()):
        # eliminating all version-history labels
        for label in list(vhistory._labels.keys()):
            if label not in self.VersionRepository._labels.keys():
                del vhistory._labels[label]
        # and eliminating versions that are not
        # referenced by the workspace_tool
        nukedVersions = 0
        for vid in list(vhistory._versions.keys()):
            if (histid, vid) not in keep_versions:
                #_removeVersion(vid, vhistory)
                _reduceVersion(vid, vhistory)
                nukedVersions +=1
        # finally, we eliminate the version history if there are no
        # more versions
        #if not vhistory._versions.keys():
        if nukedVersions == len(vhistory._versions.keys()):
            del self.VersionRepository._histories[histid]
        commiter.flag(out)

def theWholeShebang(self):
    import sys
    cleanUpESSLabels(self, sys.stdout)
    get_transaction().commit()
    self._p_jar._storage.pack()
    get_transaction().commit()
    for workspace in self.portal_workspaces.getWorkspaces():
        get_transaction().commit(1)
        workspace.publishLastChanged()
    get_transaction().commit()
