# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from Products.CMFCore.utils import getToolByName
from Products.CMFCore import permissions
from Products.CMFStaging.StagingTool import StageObjects
from StringIO import StringIO

# FIX: maybe coalesce some (or all) these data structures?
WF_MAP = {'StagingArea': 'staging_workflow'}
WF_SCRIPTS = {'staging_workflow': (
    ('incremental_deploy', 'Incremental Publish',
     'EnSimpleStaging.Workflow', 'incremental_deploy'),
    ('complete_deploy', 'Complete Publish',
     'EnSimpleStaging.Workflow', 'complete_deploy'),
    )
    }
WF_SETUP = {'staging_workflow': 'staging_workflow_setup'}
WF_SOURCE = {'staging_workflow': 'folder_workflow'}
DEFAULT_COMMENT = 'Triggered by workflow script'

def install(self, out):
    setup_workflows(self, WF_MAP, out)

def setup_workflows(self, wf_map, out):
    wft = getToolByName(self, 'portal_workflow')

    for typ, wf_id in wf_map.items():
        chain = wft.getChainFor(typ)
        source_id = WF_SOURCE[wf_id]
        if wf_id in wft.objectIds():
            print >> out, 'Workflow %s already existed, replacing'
            wft.manage_delObjects(ids=[wf_id])
        cb = wft.manage_copyObjects(ids=[source_id])
        res = wft.manage_pasteObjects(cb)
        # Again, should have only one entry here
        copy_id = res[0]['new_id']
        wft.manage_renameObject(copy_id, wf_id)
        print >> out, 'Created workflow %s from %s' % (wf_id, source_id)

        wf = wft[wf_id]
        print >> out, 'Setting up workflow %s for staging' % wf_id

        add_wf_scripts(wf, WF_SCRIPTS, out)
        setup = WF_SETUP.get(wf_id)
        if setup is not None:
            setup = globals().get(setup)
            setup(wf, out)

        wft.setChainForPortalTypes((typ,), wf_id)
        print >> out, 'Changed workflow for %s to %s' % (typ, wf_id)

def add_wf_scripts(wf, wf_scripts, out):
    scripts = wf_scripts.get(wf.id, ())
    factory = wf.scripts.manage_addProduct['ExternalMethod']
    for id, title, mod, func in scripts:
        if id not in wf.scripts.objectIds():
            print >> out, ('Adding External Method %s.%s as '
                           'script %s' % (mod, func, id))
            factory.manage_addExternalMethod(id, title, mod, func)

def staging_workflow_setup(wf, out):
    for t in ('incremental_deploy', 'complete_deploy'):
        print >> out, 'Adding transition %s' % t
        wf.transitions.addTransition(t)

    tdef = wf.transitions['incremental_deploy']
    tdef.setProperties(title='Incremental Publish', # Rename to 'Deploy'?
                       new_state_id='', # Remain in same state
                       trigger_type=1,
                       script_name='incremental_deploy',
                       after_script_name='',
                       actbox_name='Incremental Publish',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_roles': '',
                              'guard_expr': '',
                              'guard_permissions': StageObjects},
                       )

    tdef = wf.transitions['complete_deploy']
    tdef.setProperties(title='Complete Publish', # Rename to 'Deploy'?
                       new_state_id='', # Remain in same state
                       trigger_type=1,
                       script_name='complete_deploy',
                       after_script_name='',
                       actbox_name='Complete Publish',
                       actbox_url='',
                       actbox_category='workflow',
                       props={'guard_roles': '',
                              'guard_expr': '',
                              'guard_permissions': StageObjects},
                       )

##    print >> out, "removing needless states and transitions..."
##    state_ids = 'private published'.split()
##    wf.states.deleteStates(state_ids)
##    transition_ids = 'hide publish retract show'.split()
##    wf.transitions.deleteTransitions(transition_ids)

    for state_id in wf.states.objectIds():
        state = wf.states[state_id]
        transitions = state.getTransitions()
        title = state.title
        description = state.description
        transitions = list(state.getTransitions())
        for transition_id in ('incremental_deploy', 'complete_deploy'):
            if not transition_id in transitions:
                transitions.append(transition_id)
                print >> out, ('Appending %s to list of available '
                               'transitions for state %s' % (transition_id,
                                                             state_id))
        state.setProperties(title=title,
                            description=description,
                            transitions=transitions)
##        print >> out, ('Fixing permission mapping')
##        for permission_id in (permissions.AccessContentsInformation,
##                              permissions.ModifyPortalContent,
##                              permissions.View,
##                              permissions.ListFolderContents,
##                              ):
##            state.setPermission(permission_id,
##                                0, ['Manager', 'Reviewer'])
##

def incremental_deploy(self, state_change):
    stage = state_change.object
    label = stage.getNextLabel()
    comment = state_change.kwargs.get('comment', DEFAULT_COMMENT)
    stage.publishLastChanged(label=label, message=comment)

def complete_deploy(self, state_change):
    stage = state_change.object
    label = stage.getNextLabel()
    comment = state_change.kwargs.get('comment', DEFAULT_COMMENT)
    stage.publishStage(label=label, message=comment)
