# EnSimpleStaging  |  Copyright(C), 2004, Enfold Systems, LLC
# see LICENSE.txt for details

from Products.Archetypes.public import listTypes
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.ZCatalog.Catalog import CatalogError

from Products.EnSimpleStaging.config import PROJECTNAME, GLOBALS
from Products.EnSimpleStaging.config import TOOLS, DEPENDENCIES
from Products.EnSimpleStaging.Extensions import Workflow

from StringIO import StringIO

def install_vc(self, out):
    if not hasattr(self, 'VersionRepository'):
        zvc = self.manage_addProduct['ZopeVersionControl']
        zvc.addRepository('VersionRepository')
        out.write("Created Version Repository.\n")

def install_tools(self, product, tools, out):
    addTool = self.manage_addProduct[product].manage_addTool
    for toolid, toolname in tools:
        if hasattr(self, toolid):
            self.manage_delObjects(ids=[toolid])
        addTool(toolname)
        out.write("Created tool: %s (%s).\n" % (toolid, toolname))

def setup_local_tools(self, out, path='public_website'):
    from Acquisition import aq_parent, aq_base
    from Products.Archetypes.Extensions.utils import install_archetypetool
    from Products.Archetypes.Extensions.utils import install_uidcatalog
    from Products.Archetypes.Extensions.utils import install_templates
    from Products.Archetypes.Extensions.utils import install_referenceCatalog
    public = self.restrictedTraverse(path)
    # Hack around acquisition so that tools get setup correctly
    public = aq_base(public).__of__(aq_parent(self))
    aq_base(public).ESS_INSTALLING_LOCAL_TOOLS = True
    install_uidcatalog(public, out)
    install_referenceCatalog(public, out)
    install_archetypetool(public, out)
    install_templates(public, out)
    del public.ESS_INSTALLING_LOCAL_TOOLS
    out.write('Installed uid and reference catalogs on public_website.\n')

def install_qi_products(self, out, products):
    qiTool = getToolByName(self, 'portal_quickinstaller')
    for product in products:
        qiTool.installProduct(product)
        print >> out, 'Installed dependency: %s' % product

##def setup_discussion(self, out):
##    dt = getToolByName(self, 'portal_discussion')
##    from Products.PluggableDiscussion.managers.btree import uid
##    if 'workspace_discussion' not in dt.objectIds():
##        uid.addDiscussionManager(dt, 'workspace_discussion')
##        dmanager = dt['workspace_discussion']
##        dmanager.setExpression("python: getattr(object.aq_explicit, 'UID', None) is not None "
##                               "and getattr(object, 'ess_isUnderWorkspace', False)")

##        uid.addDiscussionManager(dt, 'deployed_discussion')
##        dmanager = dt['deployed_discussion']
##        dmanager.setExpression("python: getattr(object.aq_explicit, 'UID', None) is not None "
##                               "and not getattr(object, 'ess_isUnderWorkspace', False)")

##        dt.moveObjectsToTop(['workspace_discussion',
##                             'deployed_discussion',])
##        print >> out, 'configured discussions to be stored per path instead of per object'

def install(self):
    out = StringIO()

    install_qi_products(self, out, DEPENDENCIES)
    installTypes(self, out, listTypes(PROJECTNAME), PROJECTNAME)

    install_subskin(self, out, GLOBALS)
    install_vc(self, out)
    install_tools(self, PROJECTNAME, TOOLS, out)
##    setup_discussion(self, out)

    Workflow.install(self, out)

    out.write("Successfully installed %s." % PROJECTNAME)
    return out.getvalue()
