"""
$RCSfile: alltests.py,v $

Run all ExternalFile unit tests

Author: <a href="mailto:support@arielpartners.com">Ariel Partners, LLC</a>

$Id: alltests.py 320 2004-11-10 15:42:53Z sidnei $
Release 1.2
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/04/16 04:34:23 $'[6:-2]
__version__ = '$Revision: 1.2 $'[10:-2]

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

# Import the TestCase from each module
from TestProductProperties import ProductPropertiesTestCase
from TestExternalFile import ExternalFileTestCase

# Add the TestCase class to this list
unitTests = (
    ProductPropertiesTestCase,
    ExternalFileTestCase
    )

################################################################
# The rest is boilerplate: don't touch
################################################################
import unittest, os

masterSuite = unittest.TestSuite(map(lambda x: unittest.makeSuite(x, 'test'),
                                     unitTests))

runner = unittest.TextTestRunner()

if __name__ == '__main__':
    runner.run(masterSuite)
