"""
$RCSfile: TestProductProperties.py,v $
Unit tests for ExternalFile.ProductProperties module

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.2
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/04/12 16:01:16 $'[6:-2]
__version__ = '$Revision: 1.3 $'[10:-2]

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

import Products.ExternalFile.ProductProperties as pp

ZopeTestCase.installProduct('ExternalFile')
ZopeTestCase.installProduct('PageTemplates')

class ProductPropertiesTestCase(ZopeTestCase.ZopeTestCase):
    """
    Unit tests for ExternalFile product mime type and display type
    mappers
    """

    def beforeSetup(self):
        self.mimetype_file = os.path.join(os.path.dirname(pp.__file__),
                                          'etc', 'mime.types')
        self.displaytype_file = os.path.join(os.path.dirname(pp.__file__),
                                             'etc', 'display.types')

    ################################################################
    # Test Cases
    ################################################################

    def test_01(self):
        "Test mimetype mapping initialization"

        self.assertEquals(pp.getDefaultMimeType(),'application/octet-stream')

        # ensure we got all of our mimetypes
        typelist = pp.getMimeTypeList()
        self.failUnless(typelist.index('text/css') > 0)
        self.failUnless(typelist.index('application/x-jar') > 0)

        # ensure we got all of our displaytypes
        self.assertEquals(pp.getDisplayTypeFromMimeType('application/x-javascript'), 'ascii')
        self.assertEquals(pp.getDisplayTypeFromMimeType('application/xml'), 'ascii')
        self.assertEquals(pp.getDisplayTypeFromMimeType('application/x-sh'), 'ascii')
        self.assertEquals(pp.getDisplayTypeFromMimeType('application/zip'), 'binary')
        self.assertEquals(pp.getDisplayTypeFromMimeType('image/jpeg'), 'image')
        self.assertEquals(pp.getDisplayTypeFromMimeType('image/thisisadummy'), 'image')
        self.assertEquals(pp.getDisplayTypeFromMimeType('text/iamfake'), 'ascii')
        self.assertEquals(pp.getDisplayTypeFromMimeType('text/plain'), 'ascii')

    ################################################################
    # Test Runner Setup
    ################################################################

if __name__ == '__main__':
    framework(descriptions=1, verbosity=2) # 0=quiet 1=default 2=verbose
else:
    # While framework.py provides its own test_suite()
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(ProductPropertiesTestCase))
        return suite
