"""

$RCSfile: uploadCreate.py,v $

Create an instance of ExternalFile based on the passed in values.
This is an example of how to create an ExternalFile object from an
uploaded file without using the ZMI interface.  The ID of the new
object will be the basename of the target_filepath.

Standard Zope Parameters:
context (not used)
              The object on which the script is being called, also
              known as the 'acquisition parent' of the script. This
              may be the container, but varies according to the path
              through which the script is accessed.
container
              The Folder in which this script is located. This doesn't
              change unless you move the script. If the script is in a
              ZClass, the Container is the class instance.

script (not used)
              The script object itself
namespace (not used)
              When the script is called from DTML, this is the
              caller's DTML namespace, otherwise it is an empty
              namespace.
traverse_subpath (not used)
              When the script is published directly from a URL, this
              is the portion of the URL path after the script's name,
              split at slash separators into a list of
              strings. Otherwise, it is an empty list.

Special Parameters:
target_filepath
              The pathname in the server filesystem that will be the target
              of the newly minted ExternalFile instance
upload_file
              The file to be uploaded and copied into the server filesystem
              at the target_filepath

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Version: $Name:  $(1.0) $Revision: 1.2 $ $Date: 2003/04/18 03:10:45 $
Release 1.0
"""

retval = "<html><head><title>UploadCreate Results</title></head>"

if not target_filepath or not upload_file or not upload_file.filename:
    retval += "<h2>ERROR</h2><div>Missing required parameter</div>" + \
              "</body></html>"
else:
    efid = target_filepath
    efid = efid[max(string.rfind(efid,'/'),
                    string.rfind(efid,'\\'),
                    string.rfind(efid,':')
                    )+1:]

    container.manage_addProduct['ExternalFile'].addExternalFile(efid, '', '',
                                                                target_filepath,'',
                                                                upload_file)

    retval += "<html><head><title>UploadCreate Results</title><body>" + \
              "<h2>SUCCESS</h2>" + \
              "<div>Created new ExternalFile instance with the following attributes:</div>" + \
              "<div>ID: " + str(efid) + "</div>" + \
              "<div>target_filepath: " + str(target_filepath) + "</div>" + \
              "<div>upload_file: " + str(upload_file.filename) + "</div>" + \
              "</body></html>"

return retval
