"""
$RCSfile: __init__.py,v $

The ExternalFile package is a Zope product.  ExternalFile encapsulates
a file in the filesystem for use as a Zope object

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.2
"""
__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/04/21 00:56:27 $'[6:-2]
__version__ = '$Revision: 1.22 $'[10:-2]

# python builtins
import os.path
from socket import gethostname

from ExternalFile import manage_addExternalFileForm, addExternalFile
from CreationDialog import manage_addObjectViaGui, manage_confirmCreateObject, \
     manage_confirmCreateObjectForm, manage_conflictCreateObjectForm
from ExternalFileBatch import manage_addBatchViaGui, \
     manage_addBatch, illegalCharsAsString, \
     omittedDirNamesAsString, omittedDirPrefixesAsString, \
     omittedDirSuffixesAsString, omittedFileNamesAsString, \
     omittedFilePrefixesAsString, omittedFileSuffixesAsString

import ProductProperties as pp

methods = { 'manage_addExternalFileForm'      : manage_addExternalFileForm,
            'gethostname'                     : gethostname,
            'manage_confirmCreateObjectForm'  : manage_confirmCreateObjectForm,
            'manage_conflictCreateObjectForm' : manage_conflictCreateObjectForm,
            'illegalCharsAsString'            : illegalCharsAsString,
            'omittedDirNamesAsString'         : omittedDirNamesAsString,
            'omittedDirPrefixesAsString'      : omittedDirPrefixesAsString,
            'omittedDirSuffixesAsString'      : omittedDirSuffixesAsString,
            'omittedFileNamesAsString'        : omittedFileNamesAsString,
            'omittedFilePrefixesAsString'     : omittedFilePrefixesAsString,
            'omittedFileSuffixesAsString'     : omittedFileSuffixesAsString }

def initialize(context):
    """ Initialize the ExternalFile product.  This makes the object appear
    in the Zope product list menu.  initialize() is called by Zope
    when starting a Zope server.  The 'context' argument is an
    instance of App.ProductContext.ProductContext
    """

    try:
        # Grab the package directory from the python builtin __file__
        package_dir = os.path.dirname(pp.__file__)

        # Initialize our mimetype and displaytype maps
        pp.initMimeTypeList(os.path.join(package_dir, 'etc', 'mime.types'))
        pp.initDisplayTypeList(os.path.join(package_dir, 'etc', 'display.types'))

        # register this class in Zope
        context.registerClass(ExternalFile.ExternalFile,
                              constructors = (
            manage_addExternalFileForm,
            manage_confirmCreateObject,
            manage_addObjectViaGui,
            manage_addBatchViaGui,
            manage_addBatch,
            addExternalFile),
                              icon = 'www/externalFile.gif'
                              )

        context.registerHelp()
    except:
        import sys, traceback
        sys.stderr.write(''.join(traceback.format_exception(*sys.exc_info())))

# EOF __init__.py
