"""
$RCSfile: IExternalFile.py,v $

ExternalFile encapsulates a file in the filesystem for use as a Zope
object.  IExternalFile is the interface implemented by ExternalFile.

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.2
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/04/21 00:56:27 $'[6:-2]
__version__ = '$Revision: 1.7 $'[10:-2]

# Zope Base Classes
from Interface import Base

################################################################
# IExternalFile interface
################################################################

class IExternalFile(Base):
    """
    Encapsulates a file in the filesystem as a Zope object.
    """

    def getContentType():
        """
        Returns the mimetype of the file.
        """

    def getDisplayType():
        """
        Returns 'ascii', 'image', or 'binary' according to the map in
        ProductProperties.py.  Used only to control how the file is
        viewed and edited in the ZMI.
        """

    def getFilepath(REQUEST):
        """
        Return the full pathname of the external file to which we are
        referring.  The REQUEST parameter encapsulates information
        about the environment which can be used by subclasses
        overriding this method.
        """

    def getFileModTime(REQUEST):
        """
        Return the last modification date of the external file to
        which we are referring.  The value is returned as number of
        seconds since the epoch in UTC (see python time module).  The
        REQUEST parameter encapsulates information about the
        environment which can be used by subclasses overriding this
        method.
        """

    def getModTime(REQUEST):
        """
        Return the last modification date of the external file to
        which we are referring, or of our metadata which is stored
        internally in the ZODB, whichever is more recent (greater).
        The value is returned as number of seconds since the epoch in
        UTC (see python time module).  The REQUEST parameter
        encapsulates information about the environment which can be
        used by subclasses overriding this method.
        """

    def getContents(REQUEST):
        """
        Return the contents of this external file as a string.  The
        REQUEST parameter encapsulates information about the
        environment which can be used by subclasses overriding this
        method.
        """

    def setContents(newcontents, REQUEST):
        """
        Overwrite the previous contents of this file with the
        newcontents string.  The REQUEST parameter encapsulates
        information about the environment which can be used by
        subclasses overriding this method.
        """

# EOF IExternalFile.py
