"""
$RCSfile: FileUtils.py,v $

File handling routines called from multiple modules are collected
here to avoid duplication.

Author: <a href="mailto:cstrong@arielpartners.com">Craeg Strong</a>
Release: 1.2
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/04/21 00:56:27 $'[6:-2]
__version__ = '$Revision: 1.6 $'[10:-2]

# Python builtins
import os, os.path, string, types, urllib

def copy_file(infile, outfile):
    """ Read binary data from infile and write it to outfile. infile
    and outfile my be strings, in which case a file with that name is
    opened, or filehandles, in which case they are accessed directly.
    """

    if type(infile) is types.StringType:
        instream = open(infile, 'rb')
        close_in = 1
    else:
        close_in = 0
        instream = infile

    if type(outfile) is types.StringType:
        outstream = open(outfile, 'wb')
        close_out = 1
    else:
        close_out = 0
        outstream = outfile

    try:
        blocksize = 2<<16
        block = instream.read(blocksize)
        outstream.write(block)
        while len(block) == blocksize:
            block = instream.read(blocksize)
            outstream.write(block)
        instream.seek(0)
    finally:
        if close_in: instream.close()
        if close_out: outstream.close()

def create_file(contents_file, target_filepath):
    """ Creates a physical file on the filesystem at target_filepath.
    If contents_file is not None, it points to a file whose contents
    will be copied into the target file.  Otherwise, a zero length
    file will be created.  This method will raise an exception if
    there are any problems writing to the target file (or reading
    contents_file).
    """

    if contents_file:
        copy_file(contents_file, target_filepath)
    else:
        touchfile = open(target_filepath, 'wb') # create zero-length file
        touchfile.close()

sep = '\xa4' # XXX This is ugly, but os.path should be smarter :(
def safe_path_join(*args):
    args = list(args)
    parts = []

    if args:
        # On windows, drive is like 'c:', on linux it's always ''
        drive, path = os.path.splitdrive(args[0])
        args[0] = path
        parts = [drive]

    for arg in args:
        arg = arg.replace('\\', sep).replace(':', sep).replace('/', sep)
        for part in arg.split(sep):
            if part in ('.', '..'):
                continue
            # Skip empty segments
            if not part:
                continue
            parts.append(part)
    if not parts:
        return ''
    return os.path.normpath(os.path.sep.join(parts))

def clean_filename(filename):
    return filename[max(filename.rfind('/'),
                        filename.rfind('\\'),
                        filename.rfind(':'),
                        )+1:]

def extract_filename(file, default=''):
    from ZPublisher.HTTPRequest import FileUpload
    from Acquisition import aq_base

    def shasattr(obj, attr):
        return hasattr(aq_base(file), attr)

    filename = default
    if isinstance(file, FileUpload) or shasattr(file, 'filename'):
        filename = getattr(file, 'filename')
    elif isinstance(file, types.FileType) or hasattr(file, 'name'):
        filename = getattr(file, 'name')
    if not filename or filename in ('<fdopen>',):
        filename = default
    return filename

# EOF FileUtils.py
