# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: test_basic.py 482 2004-11-24 17:29:13Z sidnei $
"""

import os, sys

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
import unittest
from base import doctest, FunctionalTestCase

def walker(parent, func):
    for name, child in parent.objectItems():
        func(parent, name, child)
        walker(child, func)

def count(parent, counter):
    count = counter()
    walker(parent, count)
    count.printStats()

class Counter:

    def __init__(self):
        self.count = 0
        self.kinds = {}

    def __call__(self, parent, name, child):
        self.count += 1
        key = self.makeKey(parent, name, child)
        if not self.kinds.has_key(key):
            self.kinds[key] = 0
        self.kinds[key] += 1

    def makeKey(self, parent, name, child):
        from Acquisition import aq_base
        folderish = getattr(aq_base(child), 'isPrincipiaFolderish', None)
        return folderish and 'Folder' or 'Not-A-Folder'

    def printStats(self):
        items = self.kinds.items()
        items.sort()
        for key, value in items:
            print '%s: %s' % (key, value)
        print 'Total: %s' % self.count

class PortalTypeCounter(Counter):

    def makeKey(self, parent, name, child):
        return child.getPortalTypeName()

class ContentTypeCounter(Counter):

    def makeKey(self, parent, name, child):
        from Acquisition import aq_base
        return getattr(aq_base(child), 'content-type', None)

class RelativeURLCounter(Counter):

    def makeKey(self, parent, name, child):
        from Products.CMFCore.utils import getToolByName
        purl = getToolByName(parent, 'portal_url')
        return purl.getRelativeContentURL(child)

class PathExistsCounter(Counter):

    def makeKey(self, parent, name, child):
        import os.path
        from Products.CMFManagedFile.content import CMFManagedFile
        if not isinstance(child, CMFManagedFile):
            return 'Non-Verifiable'
        return str(os.path.exists(child.getFilepath()))

class FunctionalTest(FunctionalTestCase): pass

class ExtensionCounter(Counter):

    def makeKey(self, parent, name, child):
        import os
        return os.path.splitext(name)[-1]

def test_suite():
    suite = unittest.TestSuite()
    tests = [
        doctest.FunctionalDocFileSuite('basic_operations.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('delete.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('rename.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('import.txt',
                                       test_class=FunctionalTest,
                                       globs=globals()),
        doctest.FunctionalDocFileSuite('tool.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('policies.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('registry.txt',
                                       test_class=FunctionalTest),
        ]
    for t in tests:
        suite.addTest(t)
    return suite

if __name__ == '__main__':
    framework(descriptions=0, verbosity=1)
