# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: delete.py 482 2004-11-24 17:29:13Z sidnei $
"""

from Products.CMFManagedFile import config
from _policies import delete_policies

register = delete_policies.register

# XXX We should encapsulate the deletion policy into an object that
# implements some interface and takes the context/object for doing the
# deletion job.

register(config.DELETE_IMMEDIATE,
         name=config.DELETE_IMMEDIATE,
         title='Delete file immediately')

register(config.DELETE_DEFERRED,
         name=config.DELETE_DEFERRED,
         title='Defer file deletion')

register(config.DELETE_MANUAL,
         name=config.DELETE_MANUAL,
         title='Delete object manually')

register(config.TEMP_DOCUMENT,
         name=config.TEMP_DOCUMENT,
         title='Temporary document')
