# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: config.py 433 2004-11-22 19:02:43Z sidnei $
"""
import os
from Globals import INSTANCE_HOME

DEFAULT_PATH = os.path.join(INSTANCE_HOME, 'var', 'managed_files')
DIR_MODE = 0750

DELETE_IMMEDIATE = 'Immediate'
DELETE_DEFERRED = 'Deferred'
DELETE_MANUAL = 'Manual'
TEMP_DOCUMENT = 'Temporary'
REUSED_FILENAME = '***Reused: '
GENERATE_POLICY = 'Generated'
ORIGINAL_POLICY = 'Original'

FS_RELATIVE = 'RelativePath'
FS_PHYSICAL = 'PhysicalPath'
FS_BASE = 'BasePath'
FS_PORTAL_TYPE = 'PortalType'

TOOL_NAME = 'portal_managed_files'
