# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: __init__.py 431 2004-11-20 02:42:43Z jlaplace $
"""

import Products.CMFCore
from Products.CMFCore import utils, CMFCorePermissions
from Products.CMFCore.DirectoryView import registerDirectory

import content
import tool
import trashcan

import sys
this_module = sys.modules[ __name__ ]

contentConstructors = (content.addCMFManagedFile,)
contentClasses = (content.CMFManagedFile,)
factory_type_informations = (content.factory_type_information,)

tools = (tool.CMFManagedFileTool,)

z_bases = utils.initializeBasesPhase1(contentClasses, this_module)

# Hold a copy of globals
cmfmanagedfile_globals=globals()

# Make the skins available as DirectoryViews
registerDirectory('skins/cmfmanagedfiles', globals())

def initialize( context ):
    utils.ToolInit('CMF ManagedFile Tool', tools=tools,
                   product_name='CMFManagedFile', icon='tool.gif',
                   ).initialize( context )

    utils.initializeBasesPhase2( z_bases, context )
    context.registerHelpTitle('Help')
    context.registerHelp(directory='help')
    utils.ContentInit('CMF ManagedFile',
                      content_types = contentClasses,
                      permission = CMFCorePermissions.AddPortalContent,
                      extra_constructors = contentConstructors,
                      fti = factory_type_informations
                      ).initialize( context )

    import repository
    context.registerClass(
        repository.RepositoryContainer,
        constructors=(
        # repository.addContainerForm,
        repository.addContainer,
        ))

    context.registerClass(
        repository.Repository,
        constructors=(
        repository.manage_addRepositoryForm,
        repository.manage_addRepository,
        ))

    context.registerClass(
        trashcan.TrashCan,
        constructors=(
        # repository.addContainerForm,
        trashcan.addTrashCan,
        ))

    context.registerClass(
        trashcan.DeletedFile,
        constructors=(
        # repository.addContainerForm,
        trashcan.addDeletedFile,
        ))
