# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: Install.py 361 2004-11-12 17:26:01Z sidnei $
"""

from Globals import package_home

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.utils import minimalpath
from Products.CMFCore.TypesTool import FactoryTypeInformation as FTI

from Products.CMFManagedFile.content import CMFManagedFile
from Products.CMFManagedFile import cmfmanagedfile_globals
from Products.CMFManagedFile.config import TOOL_NAME

import os

CMF13={'immediate_view' : 'file_view',
       'download' : '',
       'view' : 'file_view',
       'edit' : 'cmfmf_edit_form',
       'metadata' : 'metadata_edit_form'}

def patch_fti(self):
    from Products.CMFCore import cmfcore_globals
    version=os.path.join( cmfcore_globals['__path__'][0], 'version.txt' )
    version=open(version, 'r').read().strip()
    if version in ('1.3', '1.3.1'):
        pt=getToolByName(self, 'portal_types')
        portal_type=pt['CMF Managed File']
        portal_type.immediate_view=CMF13['immediate_view']
        _actions=portal_type._cloneActions()
        for action in _actions:
            id=action['id']
            if id in CMF13.keys():
                action['action']=CMF13[id]
        portal_type._actions=_actions

def installSkin(self):
    st=getToolByName(self, 'portal_skins')
    skins = st.getSkinPaths()

    for skin_name, skin_path in skins:
        path_elems = [p.strip() for p in skin_path.split(',')]
        for skin in ('cmfmanagedfiles', ):
            if skin not in path_elems:
                path_elems.insert(1, skin)
        new_path = ', '.join(path_elems)
        st.addSkinSelection(skin_name, new_path)

def install(self):
    po = getToolByName(self, 'portal_url').getPortalObject()
    addTool = po.manage_addProduct['CMFManagedFile'].manage_addTool
    addTool(type='CMF ManagedFile Tool')

    tt = getToolByName(self, 'portal_types')
    ti = 'CMFManagedFile: ' + CMFManagedFile.meta_type
    tt.manage_addTypeInformation(FTI.meta_type, id='ManagedFile',
                                 typeinfo_name=ti)

    at = getToolByName(self, 'portal_actions')
    at.addActionProvider(TOOL_NAME)

    st = getToolByName(self, 'portal_skins')
    fspath = '%s/%s' % (package_home(cmfmanagedfile_globals),
                        'skins/cmfmanagedfiles')
    fspath = minimalpath(fspath)
    st.manage_addProduct['CMFCore'].manage_addDirectoryView(fspath)

    installSkin(self)

    patch_fti(self)

    return 'fin.'
