
import os, sys
import tempfile

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Testing.ZopeTestCase import user_name, user_password, folder_name
from base import FunctionalTestCase
from Testing.ZopeTestCase import user_name, user_password, folder_name

class TestExtend(FunctionalTestCase):


    def afterSetUp(self):
        FunctionalTestCase.afterSetUp(self)
        tt = self.portal.portal_types
        ti = tt.getTypeInfo('ExtATManagedFile')
        ti.global_allow = True
        self.setRoles(['Manager'])
        self.login(user_name)
        self.tmp_dir = tmp_dir = tempfile.mkdtemp()
        repos_path = os.path.join(tmp_dir, 'repos')
        os.mkdir(repos_path)
        self.test_file = tempfile.NamedTemporaryFile(dir=tmp_dir)
        self.file_contents = file_contents = 'Today is a good day to die!'
        self.test_file.write(file_contents)
        self.tool.getRepository('default').edit(path=repos_path)

    def makeOne(self, **kw):
        context = kw.get('context', self.portal)
        if kw.has_key('context'):
            del kw['context']
        context.invokeFactory('ExtATManagedFile', **kw)
        return context._getOb(kw['id'])

    def test_creation(self):
        test_file = self.test_file
        test_file.seek(0)
        obj = self.makeOne(id='file1', upload_file=test_file)
        obj = getattr(self.portal, 'file1', None)
        assert obj is not None
        assert obj.portal_type == 'ExtATManagedFile', obj.portal_type

    def test_modify(self):
        test_file = self.test_file
        test_file.seek(0)
        obj = self.makeOne(id='file1', upload_file=test_file)
        obj = getattr(self.portal, 'file1', None)
        assert obj is not None
        obj.setTest_field('This is a test')
        obj = getattr(self.portal, 'file1', None)
        assert obj is not None
        assert obj.getTest_field() == 'This is a test', obj.getTestField()

    def test_fileCreated(self):
        test_file = self.test_file
        test_file.seek(0)
        obj = self.makeOne(id='file1', upload_file=test_file)
        obj = getattr(self.portal, 'file1', None)
        assert obj is not None
        filepath = obj.filepath
        assert os.path.exists(filepath), filepath
        assert os.path.isfile(filepath), filepath
        newfile = open(filepath, 'rb')
        assert newfile.read() == self.file_contents, newfile.read()



    def test_getFileContents(self):
        test_file = self.test_file
        test_file.seek(0)
        obj = self.makeOne(id='file1', upload_file=test_file)
        obj = getattr(self.portal, 'file1', None)
        assert obj is not None
        assert obj.data() == self.file_contents, obj.data()





def test_suite():
    import unittest
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(TestExtend))
    return suite

if __name__ == '__main__':
    framework(descriptions=0, verbosity=1)
