# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: test_basic.py 483 2004-11-24 17:29:38Z sidnei $
"""

import os, sys

if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
import unittest
from base import doctest, FunctionalTestCase

class FunctionalTest(FunctionalTestCase):
    """Test basic operations: add/delete/rename"""

def test_suite():
    suite = unittest.TestSuite()
    tests = [
        doctest.FunctionalDocFileSuite('basic_operations.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('delete.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('rename.txt',
                                       test_class=FunctionalTest),
        doctest.FunctionalDocFileSuite('registry.txt',
                                       test_class=FunctionalTest),
        ]
    for t in tests:
        suite.addTest(t)
    return suite

if __name__ == '__main__':
    framework(descriptions=0, verbosity=1)
