# This work is based upon CMFExternalFile, which was developed by
# Alan Runyan with contributions by Andy McKay, Kiran Jonnalagadda
# and PloneExternalFile developed by Florian Geier.
#
# CMFManagedFile extends CMFExternalFile to include a concept that
# can be found in PloneExternalFile where uploaded documents may be
# routed to specific directories or file systems.  This is specified by the
# user at upload time through the selection of pre-defined "repositories"
# that the site administrator would define and establish.
#
# The merger of CMFExternalFile and PloneExternalFile has been further
# extended to include some aspects of managing the external files on the
# file systems.  These include the automatic deletion of the file system files
# for deleted documents of the class CMFManagedFile governed by customizable
# and user selectable deletion policies, and the automatic movement of files
# from one file system repository to another based upon an edit action
# that includes the selection of a repository other than the repository
# in which the file is currently stored.
#
"""
$Id: base.py 551 2004-12-02 01:17:08Z arunyan $
"""

from Testing import ZopeTestCase
from Testing.ZopeTestCase import doctest
from Products.CMFPlone.tests import PloneTestCase

ZopeTestCase.installProduct('ExternalFile')
ZopeTestCase.installProduct('CMFManagedFile')
ZopeTestCase.installProduct('Archetypes')
ZopeTestCase.installProduct('generator')
ZopeTestCase.installProduct('validation')
ZopeTestCase.installProduct('PortalTransforms')
ZopeTestCase.installProduct('MimetypesRegistry')
ZopeTestCase.installProduct('ATManagedFile')

try:
    ZopeTestCase.installProduct('DavPack')
except ImportError:
    print 'DavPack not installed.  DAV tests will fail'

from zExceptions.ExceptionFormatter import format_exception
from ZPublisher.HTTPResponse import HTTPResponse

# Silence Plone's handling of exceptions
orig_exception = HTTPResponse.exception
def exception(self, **kw):
    def tag_search(*args):
        return False
    kw['tag_search'] = tag_search
    return orig_exception(self, **kw)

orig_setBody = HTTPResponse.setBody
def setBody(self, *args, **kw):
    kw['is_error'] = 0
    if isinstance(args[0], tuple) and len(args[0]) == 2:
        title, body = args[0]
        args = (body,) + args[1:]
    return orig_setBody(self, *args, **kw)

def _traceback(self, t, v, tb, as_html=1):
    return ''.join(format_exception(t, v, tb, as_html=as_html))

HTTPResponse._error_format = 'text/plain'
HTTPResponse._traceback = _traceback
HTTPResponse.exception = exception
HTTPResponse.setBody = setBody

from Products.CMFCore.utils import getToolByName
from Products.CMFManagedFile.config import TOOL_NAME

class TestCase(PloneTestCase.PloneTestCase):

    def afterSetUp(self):
        self.qi = getToolByName(self.portal, 'portal_quickinstaller')
        self.qi.installProduct('CMFManagedFile')
        self.qi.installProduct('Archetypes')
        self.qi.installProduct('ATManagedFile')
        self.tool = getToolByName(self.portal, TOOL_NAME)

    def makeOne(self, **kw):
        context = kw.get('context', self.portal)
        if kw.has_key('context'):
            del kw['context']
        context.invokeFactory('AT Managed File', **kw)
        return context._getOb(kw['id'])

class FunctionalTestCase(ZopeTestCase.Functional, TestCase):
    """A functional test case of ours
    """
