# This product is licensed under the GNU Lesser General Public License:
#
# ATManagedFile  |  Copyright(C), 2004, Enfold Systems, LLC
#
# Enfold Systems, LLC
# 4500 Montrose Blvd., Suite D
# Houston, Texas 77006 USA
# p. +1 713.942.2377 | f. +1 832.201.8856
# www.enfoldsystems.com
# info@enfoldsystems.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1 of the
# License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
# License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# For a full copy of the license, please see the included 'LGPL.txt' file.

import os

from Products.Archetypes.public import *
from Products.Archetypes.utils import shasattr
from Products.Archetypes.Storage import Storage
from Products.Archetypes.Widget import FileWidget, registerWidget
from Products.CMFCore.utils import getToolByName
from Products.CMFManagedFile.content import ManagedFileMixin
from Products.ExternalFile.ProductProperties import getMimeTypeFromFile
from Products.ExternalFile.FileUtils import extract_filename, clean_filename


class ManagedFileStorage(Storage):

    def get(self, name, instance, **kwargs):
        data = ManagedFileMixin.getContents(instance, instance.REQUEST)
        if isinstance(data, IOError):
            data = ''
        return data

    def set(self, name, instance, value, **kwargs):
        new_filename = clean_filename(extract_filename(value))
        content_type = getMimeTypeFromFile(new_filename)
        repository_id = instance.getRepository()
        if repository_id is not None:
            repository = getToolByName(instance, 'portal_managed_files')
            info = repository.getRepositoryInfo(repository_id)
            if info[2]=='Original':
                filename = instance.getProperty('filename', None)
                if not filename:
                    # have to do this so that id gets set
                    instance._updateProperty('filename', new_filename)
                    filepath = repository.getFilesystemPathFor(instance)
                    instance._updateProperty('filepath', filepath)
                    
        ManagedFileMixin.edit(instance, file=value)

        # After the instance has been modified. We can look to see
        # If a new content_type was changed.  This could happen if
        # value was a raw file handle.  Always trust the mixin edit.

        if instance.content_type != content_type:
            content_type = instance.content_type

        # Update content_type as the last step, because if we use
        # Original filename policy it will use the id inside plone to
        # detect the content type and may detect it wrongly.
        instance._updateProperty('content_type', content_type)

class ManagedFileWidget(FileWidget):
    _properties = FileWidget._properties.copy()
    _properties.update({
        'macro':'atmanaged_file_widget'
        })

registerWidget(ManagedFileWidget,
               title='Managed File Widget',
               description=('Same as a FileWidget but ExternalEditor path'
                            'has been customized'),
               used_for=('Products.ATManagedFile.schema.ManagedFileField',)
               )


class ManagedFileField(FileField):

    def getContentType(self, instance, fromBaseUnit=False):
        return instance.content_type

    def set(self, instance, value, **kwargs):
        ObjectField.set(self, instance, value, **kwargs)

    def getFilename(self, instance, fromBaseUnit=False):
        return instance.getProperty('filename', '')


managed_file_schema = Schema((
        ManagedFileField('file',
                         required=True,
                         primary=True,
                         storage=ManagedFileStorage(),
                         widget=ManagedFileWidget(label='File')
                         ),
        StringField('repository',
                    vocabulary='getRepositories',
                    widget=SelectionWidget(label='Target Repository')
                    ),
        StringField('deletePolicy',
                    vocabulary='getDeletePolicies',
                    widget=SelectionWidget(label='Deletion Policy')
                    )
        ), marshall=PrimaryFieldMarshaller())
