# This product is licensed under the GNU Lesser General Public License:
#
# ATManagedFile  |  Copyright(C), 2004, Enfold Systems, LLC
#
# Enfold Systems, LLC
# 4500 Montrose Blvd., Suite D
# Houston, Texas 77006 USA
# p. +1 713.942.2377 | f. +1 832.201.8856
# www.enfoldsystems.com
# info@enfoldsystems.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1 of the
# License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
# License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# For a full copy of the license, please see the included 'LGPL.txt' file.


from Products.Archetypes.public import *
from Products.CMFManagedFile.content import ManagedFileMixin, deleteHook
from Products.CMFManagedFile.content import addManagedFile

from schema import managed_file_schema
from AccessControl import ClassSecurityInfo
from Products.CMFCore.CMFCorePermissions import View, ModifyPortalContent
from Products.CMFCore.utils import getToolByName

from Products.CMFManagedFile.config import *
from ComputedAttribute import ComputedAttribute
from config import CHAR_MAPPING, GOOD_CHARS
from Acquisition import aq_parent

def cleanupFilename(filename):
    """Removes bad chars from file names to make them a good id
    """
    result = ''
    for s in str(filename):
        s = CHAR_MAPPING.get(s, s)
        if s in GOOD_CHARS:
            result+=s
    return result


def addATManagedFile(*args, **kw):
    kw['factory'] = ATManagedFile
    container = args[0]
    id = addManagedFile(*args, **kw)
    obj = container._getOb(id)
    # if we don't do this the filename and filepath will be wrong when adding
    # from plone, i.e. the filename will be the autogenerated id
    if not kw.get('target_filepath', None) and not kw.get('upload_file', None):
        obj._updateProperty('filename', '')
        obj._updateProperty('filepath', '')
    return id

BaseContentSchema = BaseContent.schema.copy()
BaseContentSchema['title'].required = False

class ATManagedFile(BaseContent, ManagedFileMixin):
    """ Archetypes-based Managed File
    """

    meta_type = portal_type = archetype_name = 'AT Managed File'

    schema = BaseContentSchema + managed_file_schema

    security = ClassSecurityInfo()

    _properties = tuple(ManagedFileMixin._properties)

    def __init__(self, id, title='', description='', filesystempath=''):
        ManagedFileMixin.__init__(self, id, title, description, filesystempath)

    def _notifyOfCopyTo(self, container, op=0):
        ManagedFileMixin._notifyOfCopyTo(self, container, op)
        BaseContent._notifyOfCopyTo(self, container, op)

    def manage_beforeDelete(self, item, container):
        ManagedFileMixin.manage_beforeDelete(self, item, container)
        BaseContent.manage_beforeDelete(self, item, container)

    security.declareProtected(ModifyPortalContent, 'setRepository')
    def setRepository(self, value, **kwargs):
        ManagedFileMixin.edit(self, repository=value)

    security.declareProtected(View, 'getSize')
    getSize = ManagedFileMixin.get_size

    security.declareProtected(View, 'get_size')
    get_size = getSize

    security.declareProtected(View, 'at_download')
    at_download = ManagedFileMixin.download

    security.declareProtected(View, 'index_html')
    def index_html(self):
        """ return """
        return ManagedFileMixin.download(self)

    security.declareProtected(ModifyPortalContent, 'setFile')
    def setFile(self, value, **kwargs):
        """Set id to uploaded id"""
        field = self.getPrimaryField()
        field.set(self, value, **kwargs)
        if not self._useOriginalFilename():
            return
        if self._isIDAutoGenerated(self.getId()):
            filename = field.getFilename(self)
            clean_filename = cleanupFilename(filename)
            if self.REQUEST.form.get('id'):
                return
            elif clean_filename == self.getId():
                return
            elif clean_filename:
                aq_parent(self).manage_renameObject(self.getId(),
                        clean_filename)

    def _useOriginalFilename(self):
        request = self.REQUEST
        repository = request.get('repository', None) or self.getRepository()
        mft = getToolByName(self, 'portal_managed_files')
        info = mft.getRepositoryInfo(repository)
        if info:
            if info[2] == 'Original':
                return True
        return False


    def _isIDAutoGenerated(self, id):
        skinstool = getToolByName(self, 'portal_skins')
        script = getattr(skinstool.aq_explicit, 'isIDAutoGenerated', None)
        if script:
            return script(id)
        else:
            return False


    security.declareProtected(ModifyPortalContent, 'update')
    def update(self, **kwargs):
        """Alias for edit()
        """
        self.edit(**kwargs)

    security.declareProtected(ModifyPortalContent, 'edit')
    def edit(self, **kwargs):
        """Call edit from ManagedFileMixin and BaseContent
        """
        ManagedFileMixin.edit(self,
                              precondition=kwargs.get('precondition', ''),
                              file=kwargs.get('file', ''),
                              repository=kwargs.get('repository', ''),
                              delete_policy=kwargs.get('delete_policy', ''))
        BaseContent.update(self, **kwargs)

registerType(ATManagedFile)
