# This product is licensed under the GNU Lesser General Public License:
#
# ATManagedFile  |  Copyright(C), 2004, Enfold Systems, LLC
#
# Enfold Systems, LLC
# 4500 Montrose Blvd., Suite D
# Houston, Texas 77006 USA
# p. +1 713.942.2377 | f. +1 832.201.8856
# www.enfoldsystems.com
# info@enfoldsystems.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1 of the
# License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
# License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# For a full copy of the license, please see the included 'LGPL.txt' file.


from StringIO import StringIO
from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.CMFCore.utils import getToolByName

from Products.ATManagedFile.config import *

def installDeps(self, out):
    qi = getToolByName(self, 'portal_quickinstaller')
    for dep in DEPS:
        qi.installProduct(dep)
    print >> out, 'Dependencies Installed'

def setupTypes(self, out):
    types = listTypes(PROJECTNAME)
    installTypes(self, out, types, PROJECTNAME)
    tt = getToolByName(self, 'portal_types')
    ti = tt.getTypeInfo('ManagedFile')
    ti.global_allow = False
    print >> out, 'Types Installed'

def setupSkins(self, out):
    install_subskin(self, out, GLOBALS)
    print >> out, 'Skins Installed'

def install(self):
    out = StringIO()
    installDeps(self, out)
    setupTypes(self, out)
    setupSkins(self, out)
    return out.getvalue()
