# This product is licensed under the GNU Lesser General Public License:
#
# ATMFExample  |  Copyright(C), 2004, Enfold Systems, LLC
#
# Enfold Systems, LLC
# 4500 Montrose Blvd., Suite D
# Houston, Texas 77006 USA
# p. +1 713.942.2377 | f. +1 832.201.8856
# www.enfoldsystems.com
# info@enfoldsystems.com
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1 of the
# License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
# License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# For a full copy of the license, please see the included 'LGPL.txt' file.

from Products.Archetypes.public import *
from Products.ATManagedFile.content import ATManagedFile
from Products.CMFManagedFile.content import addManagedFile

from schema import example_schema

def addATMFExample(*args, **kw):
    kw['factory'] = ATMFExample
    obj = addManagedFile(*args, **kw)
    # if we don't do this the filename and filepath will be wrong when adding
    # from plone
    if not kw.get('target_filepath', None) and not kw.get('upload_file', None):
        obj._updateProperty('filename', '')
        obj._updateProperty('filepath', '')


class ATMFExample(ATManagedFile):

    meta_type = portal_type = archetype_name = 'ATMF Example'

    schema = ATManagedFile.schema + example_schema

registerType(ATMFExample)
